/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.imwrapper.jabber;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.wso2.imwrapper.core.IMException;
import org.wso2.imwrapper.core.IMWrapper;

public class JabberWrapperImpl
implements IMWrapper {
    private static Log log = LogFactory.getLog((Class)(class$org$wso2$imwrapper$jabber$JabberWrapperImpl == null ? (class$org$wso2$imwrapper$jabber$JabberWrapperImpl = JabberWrapperImpl.class$("org.wso2.imwrapper.jabber.JabberWrapperImpl")) : class$org$wso2$imwrapper$jabber$JabberWrapperImpl));
    boolean loginProcessed = false;
    boolean loggedIn = false;
    XMPPConnection connection;
    static /* synthetic */ Class class$org$wso2$imwrapper$jabber$JabberWrapperImpl;

    public void login(String userID, String password) throws IMException {
        int index = userID.indexOf("@");
        if (index < 1 || userID.length() == index + 1) {
            log.error((Object)"The format of the userID is incorrect. The userID must be of the form userName@jabberServer");
            throw new IMException("The format of the userID is incorrect. The userID must be of the form userName@jabberServer");
        }
        String username = userID.substring(0, index);
        String serverName = userID.substring(index + 1);
        this.connection = new XMPPConnection(serverName);
        try {
            this.connection.connect();
            this.connection.login(username, password);
        }
        catch (XMPPException e) {
            this.loginProcessed = true;
            this.loggedIn = false;
            log.error((Object)e);
            throw new IMException(e);
        }
        this.loginProcessed = true;
        this.loggedIn = true;
    }

    public void sendMessage(String to, String message) throws IMException {
        if (!this.loginProcessed || !this.loggedIn) {
            log.error((Object)"Got to Log in before a message can be sent.");
            throw new IMException("Got to Log in before a message can be sent.");
        }
        Message chatMessage = new Message();
        chatMessage.setTo(to);
        chatMessage.setBody(message);
        chatMessage.setType(Message.Type.normal);
        this.connection.sendPacket((Packet)chatMessage);
    }

    public void disconnect() throws IMException {
        if (this.connection != null) {
            this.connection.disconnect();
            this.loginProcessed = false;
            this.loggedIn = false;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Connection to jabber server disconnected");
            }
        } else {
            log.error((Object)"Cannot disconnect cause the connection is not made as yet");
            throw new IMException("Cannot disconnect cause the connection is not made as yet");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

