/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.imwrapper.msn;

import net.sf.jml.Email;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnMessenger;
import net.sf.jml.MsnSwitchboard;
import net.sf.jml.event.MsnAdapter;
import net.sf.jml.event.MsnContactListAdapter;
import net.sf.jml.event.MsnContactListListener;
import net.sf.jml.event.MsnMessengerListener;
import net.sf.jml.event.MsnSwitchboardAdapter;
import net.sf.jml.event.MsnSwitchboardListener;
import net.sf.jml.impl.MsnMessengerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.imwrapper.core.IMException;
import org.wso2.imwrapper.core.IMWrapper;

public class MSNWrapperImpl
implements IMWrapper {
    MsnMessenger messenger = null;
    boolean loginProcessed = false;
    boolean loggedIn = false;
    String errorMessage;
    int messageCount = 0;
    boolean disconnectCalled = false;
    private static Log log = LogFactory.getLog((Class)(class$org$wso2$imwrapper$msn$MSNWrapperImpl == null ? (class$org$wso2$imwrapper$msn$MSNWrapperImpl = MSNWrapperImpl.class$("org.wso2.imwrapper.msn.MSNWrapperImpl")) : class$org$wso2$imwrapper$msn$MSNWrapperImpl));
    static /* synthetic */ Class class$org$wso2$imwrapper$msn$MSNWrapperImpl;

    public void login(String userID, String password) throws IMException {
        this.messenger = MsnMessengerFactory.createMsnMessenger((String)userID, (String)password);
        this.messenger.addMessengerListener((MsnMessengerListener)new MsnAdapter(){

            public void loginCompleted(MsnMessenger messenger) {
                MSNWrapperImpl.this.loginProcessed = false;
                MSNWrapperImpl.this.loggedIn = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Signed into MSN, Waiting till Contact List Init complete");
                }
            }

            public void exceptionCaught(MsnMessenger msnMessenger, Throwable throwable) {
                MSNWrapperImpl.this.loginProcessed = true;
                MSNWrapperImpl.this.errorMessage = throwable.getMessage();
                log.error((Object)throwable);
            }
        });
        this.messenger.addContactListListener((MsnContactListListener)new MsnContactListAdapter(){

            public void contactListInitCompleted(MsnMessenger messenger) {
                MSNWrapperImpl.this.loginProcessed = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Contact List Init completed");
                }
            }
        });
        this.messenger.login();
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
        } while (!this.loginProcessed);
        if (!this.loggedIn) {
            throw new IMException(this.errorMessage);
        }
    }

    public void sendMessage(String to, String message) throws IMException {
        String text;
        Email email;
        if (this.disconnectCalled) {
            throw new IMException("Unable to send message cause the IM connection is been disconnected");
        }
        if (this.loginProcessed && this.loggedIn) {
            email = Email.parseStr((String)to);
            text = message;
            ++this.messageCount;
            MsnSwitchboard[] switchboards = this.messenger.getActiveSwitchboards();
            for (int i = 0; i < switchboards.length; ++i) {
                MsnSwitchboard switchboard1 = switchboards[i];
                if (!switchboard1.containContact(email) || switchboard1.getAllContacts().length != 1) continue;
                switchboard1.sendText(text);
                --this.messageCount;
                return;
            }
        } else {
            log.error((Object)"Got to Log in before a message can be sent.");
            throw new IMException("Got to Log in before a message can be sent.");
        }
        final Object attachment = new Object();
        this.messenger.addSwitchboardListener((MsnSwitchboardListener)new MsnSwitchboardAdapter(){

            public void switchboardStarted(MsnSwitchboard switchboard) {
                if (switchboard.getAttachment() == attachment) {
                    switchboard.inviteContact(email);
                }
            }

            public void contactJoinSwitchboard(MsnSwitchboard switchboard, MsnContact contact) {
                if (switchboard.getAttachment() == attachment && email.equals((Object)contact.getEmail())) {
                    switchboard.setAttachment(null);
                    MSNWrapperImpl.this.messenger.removeSwitchboardListener((MsnSwitchboardListener)this);
                    switchboard.sendText(text);
                    --MSNWrapperImpl.this.messageCount;
                }
            }
        });
        this.messenger.newSwitchboard(attachment);
    }

    public void disconnect() throws IMException {
        if (this.messenger != null) {
            while (this.messageCount > 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    log.error((Object)e);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Connection to MSN disconnected");
            }
        } else {
            log.error((Object)"Cannot disconnect cause the connection is not made as yet");
            throw new IMException("Cannot disconnect cause the connection is not made as yet");
        }
        this.messenger.logout();
        this.loginProcessed = false;
        this.loggedIn = false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

