/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.imwrapper.oscar;

import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.AimConnectionProperties;
import net.kano.joustsim.oscar.AimSession;
import net.kano.joustsim.oscar.DefaultAppSession;
import net.kano.joustsim.oscar.State;
import net.kano.joustsim.oscar.StateEvent;
import net.kano.joustsim.oscar.StateListener;
import net.kano.joustsim.oscar.oscar.service.icbm.ImConversation;
import net.kano.joustsim.oscar.oscar.service.icbm.Message;
import net.kano.joustsim.oscar.oscar.service.icbm.SimpleMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.imwrapper.core.IMException;
import org.wso2.imwrapper.core.IMWrapper;

public class OscarWrapperImpl
implements IMWrapper {
    private static Log log = LogFactory.getLog((Class)(class$org$wso2$imwrapper$oscar$OscarWrapperImpl == null ? (class$org$wso2$imwrapper$oscar$OscarWrapperImpl = OscarWrapperImpl.class$("org.wso2.imwrapper.oscar.OscarWrapperImpl")) : class$org$wso2$imwrapper$oscar$OscarWrapperImpl));
    AimConnection aimConnection;
    boolean loginProcessed = false;
    boolean loggedIn = false;
    static /* synthetic */ Class class$org$wso2$imwrapper$oscar$OscarWrapperImpl;

    public void login(String userID, String password) throws IMException {
        DefaultAppSession session = new DefaultAppSession();
        AimSession aimSession = session.openAimSession(new Screenname(userID));
        this.aimConnection = aimSession.openConnection(new AimConnectionProperties(new Screenname(userID), password));
        AimConnStateListener aimConnStateListener = new AimConnStateListener();
        this.aimConnection.addStateListener((StateListener)aimConnStateListener);
        this.aimConnection.connect();
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
        } while (!this.loginProcessed);
        if (!this.loggedIn) {
            throw new IMException("Connection was not succesfull");
        }
    }

    public void sendMessage(String to, String message) throws IMException {
        ImConversation imConversation;
        if (this.loginProcessed && this.loggedIn) {
            imConversation = this.aimConnection.getIcbmService().getImConversation(new Screenname(to));
            imConversation.open();
            if (!imConversation.canSendMessage()) {
                log.error((Object)("Cound not send the message to: " + to));
                throw new IMException("Cound not send the message to: " + to);
            }
            imConversation.sendMessage((Message)new SimpleMessage(message));
        } else {
            log.error((Object)"Got to Log in before a message can be sent.");
            throw new IMException("Got to Log in before a message can be sent.");
        }
        imConversation.close();
    }

    public void disconnect() throws IMException {
        if (this.aimConnection != null) {
            this.aimConnection.disconnect();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Connection disconnected");
            }
        } else {
            log.error((Object)"Cannot disconnect cause the connection is not made as yet");
            throw new IMException("Cannot disconnect cause the connection is not made as yet");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class AimConnStateListener
    implements StateListener {
        private AimConnStateListener() {
        }

        public void handleStateChange(StateEvent event) {
            State newState = event.getNewState();
            if (newState == State.ONLINE) {
                OscarWrapperImpl.this.loggedIn = true;
                OscarWrapperImpl.this.loginProcessed = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Connection made. Login Succesfull");
                }
            } else if (newState == State.FAILED) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Connection failed.");
                }
                OscarWrapperImpl.this.loggedIn = false;
                OscarWrapperImpl.this.loginProcessed = true;
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Current state is: " + newState));
            }
        }
    }
}

