/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.imwrapper.yahoo;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.imwrapper.core.IMException;
import org.wso2.imwrapper.core.IMWrapper;

public class YahooWrapperImpl
implements IMWrapper {
    Class sessionClass;
    Object session = null;
    private boolean loginProcessed = false;
    private boolean loggedIn = false;
    private final String EXCEPTION = "Cannot find yahoo library in the class path. Please make sure its in the classpath.";
    private static Log log = LogFactory.getLog((Class)(class$org$wso2$imwrapper$yahoo$YahooWrapperImpl == null ? (class$org$wso2$imwrapper$yahoo$YahooWrapperImpl = YahooWrapperImpl.class$("org.wso2.imwrapper.yahoo.YahooWrapperImpl")) : class$org$wso2$imwrapper$yahoo$YahooWrapperImpl));
    static /* synthetic */ Class class$org$wso2$imwrapper$yahoo$YahooWrapperImpl;
    static /* synthetic */ Class class$java$lang$String;

    public void login(String userID, String password) throws IMException {
        block6: {
            try {
                this.sessionClass = Class.forName("ymsg.network.Session");
                this.session = this.sessionClass.newInstance();
                Method method = this.sessionClass.getMethod("login", class$java$lang$String == null ? (class$java$lang$String = YahooWrapperImpl.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = YahooWrapperImpl.class$("java.lang.String")) : class$java$lang$String);
                method.invoke(this.session, userID, password);
                this.loggedIn = true;
                this.loginProcessed = true;
            }
            catch (ClassNotFoundException e) {
                throw new IMException("Cannot find yahoo library in the class path. Please make sure its in the classpath.");
            }
            catch (IllegalAccessException e) {
                throw new IMException("Cannot find yahoo library in the class path. Please make sure its in the classpath.");
            }
            catch (InstantiationException e) {
                throw new IMException("Cannot find yahoo library in the class path. Please make sure its in the classpath.");
            }
            catch (NoSuchMethodException e) {
                throw new IMException("Cannot find yahoo library in the class path. Please make sure its in the classpath.");
            }
            catch (Exception e) {
                Throwable throwable = e.getCause();
                if (throwable == null || !"ymsg.network.LoginRefusedException".equals(throwable.getClass().getName())) break block6;
                this.loggedIn = false;
                this.loginProcessed = true;
                throw new IMException(throwable.getMessage());
            }
        }
    }

    public void sendMessage(String to, String message) throws IMException {
        if (this.loginProcessed && this.loggedIn) {
            try {
                Method method = this.sessionClass.getMethod("sendMessage", class$java$lang$String == null ? (class$java$lang$String = YahooWrapperImpl.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = YahooWrapperImpl.class$("java.lang.String")) : class$java$lang$String);
                method.invoke(this.session, to, message);
            }
            catch (NoSuchMethodException e) {
                throw new IMException("Cannot find yahoo library in the class path. Please make sure its in the classpath.");
            }
            catch (InvocationTargetException e) {
                throw new IMException("Cannot find yahoo library in the class path. Please make sure its in the classpath.");
            }
            catch (IllegalAccessException e) {
                throw new IMException("Cannot find yahoo library in the class path. Please make sure its in the classpath.");
            }
        } else {
            log.error((Object)"Got to Log in before a message can be sent.");
            throw new IMException("Got to Log in before a message can be sent.");
        }
    }

    public void disconnect() throws IMException {
        if (this.session != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Connection to Yahoo disconnected");
            }
            try {
                Method method = this.sessionClass.getMethod("logout", new Class[0]);
                method.invoke(this.session, new Object[0]);
                this.loginProcessed = false;
                this.loggedIn = false;
            }
            catch (NoSuchMethodException e) {
                throw new IMException("Cannot find yahoo library in the class path. Please make sure its in the classpath.");
            }
            catch (InvocationTargetException e) {
                throw new IMException("Cannot find yahoo library in the class path. Please make sure its in the classpath.");
            }
            catch (IllegalAccessException e) {
                throw new IMException("Cannot find yahoo library in the class path. Please make sure its in the classpath.");
            }
        } else {
            log.error((Object)"Cannot disconnect cause the connection is not made as yet");
            throw new IMException("Cannot disconnect cause the connection is not made as yet");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

