/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.qsg;

import java.io.File;
import java.util.HashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.wso2.mdm.qsg.dto.EMMQSGConfig;
import org.wso2.mdm.qsg.dto.HTTPResponse;
import org.wso2.mdm.qsg.dto.MobileApplication;
import org.wso2.mdm.qsg.utils.HTTPInvoker;
import org.wso2.mdm.qsg.utils.QSGUtils;

public class AppOperations {
    private static String appmPublisherMobileBinariesUrl = "/api/appm/publisher/v1.1/apps/mobile/binaries";
    private static String appmPublisherResourcesUrl = "/api/appm/publisher/v1.1/apps/static-contents?appType=mobileapp";
    private static String appmPublisherAppsUrl = "/api/appm/publisher/v1.1/apps/mobileapp";

    public static MobileApplication uploadApplication(String platform, String appName, String appContentType) {
        String filePath;
        String appUploadEndpoint = EMMQSGConfig.getInstance().getEmmHost() + appmPublisherMobileBinariesUrl;
        HTTPResponse httpResponse = HTTPInvoker.uploadFile(appUploadEndpoint, filePath = "apps" + File.separator + platform + File.separator + appName, appContentType);
        if (200 == httpResponse.getResponseCode()) {
            JSONObject appMeta = null;
            MobileApplication application = new MobileApplication();
            try {
                appMeta = (JSONObject)new JSONParser().parse(httpResponse.getResponse());
                application.setPackageId((String)appMeta.get("package"));
                application.setAppId(QSGUtils.getResourceId((String)appMeta.get("path")));
                application.setVersion((String)appMeta.get("version"));
                application.setPlatform(platform);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return application;
        }
        return null;
    }

    public static MobileApplication getPublicApplication(String packageId, String version, String platform) {
        MobileApplication application = new MobileApplication();
        application.setVersion(version);
        application.setPackageId(packageId);
        application.setPlatform(platform);
        return application;
    }

    private static String uploadAsset(String path) {
        String resUploadEndpoint = EMMQSGConfig.getInstance().getEmmHost() + appmPublisherResourcesUrl;
        HTTPResponse httpResponse = HTTPInvoker.uploadFile(resUploadEndpoint, path, "image/jpeg");
        if (200 == httpResponse.getResponseCode()) {
            JSONObject resp = null;
            try {
                resp = (JSONObject)new JSONParser().parse(httpResponse.getResponse());
                return (String)resp.get("id");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static MobileApplication uploadAssets(String platform, MobileApplication application) {
        String assetDir = "apps" + File.separator + platform + File.separator + "images";
        String imgFile = assetDir + File.separator + "icon.jpg";
        String uploadPath = AppOperations.uploadAsset(imgFile);
        if (uploadPath == null || uploadPath.isEmpty()) {
            System.out.println("Unable to upload the app icon file.");
            return null;
        }
        application.setIcon(uploadPath);
        imgFile = assetDir + File.separator + "banner.jpg";
        uploadPath = AppOperations.uploadAsset(imgFile);
        if (uploadPath == null || uploadPath.isEmpty()) {
            System.out.println("Unable to upload the app banner file.");
            return null;
        }
        application.setBanner(uploadPath);
        imgFile = assetDir + File.separator + "screen1.jpg";
        uploadPath = AppOperations.uploadAsset(imgFile);
        if (uploadPath == null || uploadPath.isEmpty()) {
            System.out.println("Unable to upload the app screenshot1 file.");
            return null;
        }
        application.setScreenshot1(uploadPath);
        imgFile = assetDir + File.separator + "screen2.jpg";
        uploadPath = AppOperations.uploadAsset(imgFile);
        if (uploadPath == null || uploadPath.isEmpty()) {
            System.out.println("Unable to upload the app screenshot2 file.");
            return null;
        }
        application.setScreenshot2(uploadPath);
        imgFile = assetDir + File.separator + "screen3.jpg";
        uploadPath = AppOperations.uploadAsset(imgFile);
        if (uploadPath == null || uploadPath.isEmpty()) {
            System.out.println("Unable to upload the app screenshot3 file.");
            return null;
        }
        application.setScreenshot3(uploadPath);
        return application;
    }

    public static boolean addApplication(String name, MobileApplication mblApp, boolean isEnterpriseApp) {
        HashMap<String, String> headers = new HashMap<String, String>();
        String appEndpoint = EMMQSGConfig.getInstance().getEmmHost() + appmPublisherAppsUrl;
        JSONObject application = new JSONObject();
        application.put("name", name);
        application.put("description", "Sample application");
        application.put("type", "enterprise");
        JSONObject appMeta = new JSONObject();
        appMeta.put("package", mblApp.getPackageId());
        appMeta.put("version", mblApp.getVersion());
        if (isEnterpriseApp) {
            application.put("marketType", "enterprise");
            appMeta.put("path", mblApp.getAppId());
        } else {
            application.put("marketType", "public");
        }
        application.put("provider", "admin");
        application.put("displayName", name);
        application.put("category", "Business");
        application.put("thumbnailUrl", mblApp.getIcon());
        application.put("version", mblApp.getVersion());
        application.put("banner", mblApp.getBanner());
        application.put("platform", mblApp.getPlatform());
        application.put("appType", mblApp.getPlatform());
        application.put("mediaType", "application/vnd.wso2-mobileapp+xml");
        JSONArray screenshots = new JSONArray();
        screenshots.add(mblApp.getScreenshot1());
        screenshots.add(mblApp.getScreenshot2());
        screenshots.add(mblApp.getScreenshot3());
        application.put("appmeta", appMeta);
        application.put("screenshots", screenshots);
        headers.put("Content-Type", "application/json");
        HTTPResponse httpResponse = HTTPInvoker.sendHTTPPostWithOAuthSecurity(appEndpoint, application.toJSONString(), headers);
        return 200 == httpResponse.getResponseCode();
    }
}

