/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.qsg;

import java.util.HashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.wso2.mdm.qsg.dto.EMMQSGConfig;
import org.wso2.mdm.qsg.dto.HTTPResponse;
import org.wso2.mdm.qsg.utils.HTTPInvoker;

public class PolicyOperations {
    public static boolean createPasscodePolicy(String policyName, String deviceType) {
        HashMap<String, String> headers = new HashMap<String, String>();
        String policyEndpoint = EMMQSGConfig.getInstance().getEmmHost() + "/api/device-mgt/v1.0/policies";
        JSONObject policyData = new JSONObject();
        policyData.put("policyName", policyName);
        policyData.put("description", "Passcode Policy");
        policyData.put("compliance", "enforce");
        policyData.put("ownershipType", "ANY");
        policyData.put("active", false);
        JSONObject profile = new JSONObject();
        profile.put("profileName", "passcode");
        profile.put("deviceType", deviceType);
        JSONArray featureList = new JSONArray();
        JSONObject feature = new JSONObject();
        feature.put("featureCode", "PASSCODE_POLICY");
        feature.put("deviceType", deviceType);
        JSONObject featureContent = new JSONObject();
        featureContent.put("allowSimple", false);
        featureContent.put("requireAlphanumeric", true);
        featureContent.put("minLength", "5");
        featureContent.put("minComplexChars", "2");
        featureContent.put("maxPINAgeInDays", 7);
        featureContent.put("pinHistory", 7);
        featureContent.put("maxFailedAttempts", null);
        feature.put("content", featureContent);
        featureList.add(feature);
        profile.put("profileFeaturesList", featureList);
        JSONArray roles = new JSONArray();
        roles.add("emm-user");
        policyData.put("profile", profile);
        policyData.put("roles", roles);
        headers.put("Content-Type", "application/json");
        HTTPResponse httpResponse = HTTPInvoker.sendHTTPPostWithOAuthSecurity(policyEndpoint, policyData.toJSONString(), headers);
        return httpResponse.getResponseCode() == 201;
    }
}

