/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.qsg;

import org.wso2.mdm.qsg.AppOperations;
import org.wso2.mdm.qsg.PolicyOperations;
import org.wso2.mdm.qsg.UserOperations;
import org.wso2.mdm.qsg.dto.MobileApplication;
import org.wso2.mdm.qsg.utils.HTTPInvoker;
import org.wso2.mdm.qsg.utils.QSGUtils;

public class QSGExecutor {
    private static String iotAdminUser = "chris";
    private static String iotAdminPassword = "chrisadmin";
    private static String iotAdminEmail = "chris@mobx.com";
    private static String iotMobileUser = "alex";
    private static String iotMobileUserPassword = "alexuser";
    private static String roleName = "iotMobileUser";

    public static void main(String[] args) {
        boolean status = false;
        String email = "alex@example.com";
        String token = QSGUtils.getOAuthToken();
        if (token == null) {
            System.out.println("Unable to get the OAuth token. Please check the config.properties file.");
            System.exit(0);
        }
        HTTPInvoker.oAuthToken = token;
        System.out.println("Creating users ");
        status = UserOperations.createUser(iotAdminUser, iotAdminEmail, true);
        if (!status) {
            System.out.println("Unable to create the admin user. Please check the config.properties file.");
            System.exit(0);
        }
        if (!(status = UserOperations.changePassword(iotAdminUser, iotAdminPassword))) {
            System.out.println("Unable to change the password of the admin user. Terminating the IoTS QSG now.");
            System.exit(0);
        }
        if (!(status = UserOperations.createUser(iotMobileUser, email, false))) {
            System.out.println("Unable to create the iot user ryan. Terminating the IoTS QSG now.");
            System.exit(0);
        }
        if (!(status = UserOperations.changePassword(iotMobileUser, iotMobileUserPassword))) {
            System.out.println("Unable to change the password of the iot user. Terminating the IoTS QSG now.");
            System.exit(0);
        }
        System.out.println("Creating iotMobileUser role");
        status = UserOperations.createRole(roleName, new String[]{iotMobileUser});
        if (!status) {
            System.out.println("Unable to create the emm user role. Terminating the IoTs QSG now.");
            System.exit(0);
        }
        System.out.println("Adding sample policies ");
        status = PolicyOperations.createPasscodePolicy("android-passcode-policy1", "android");
        if (!status) {
            System.out.println("Unable to create the android passcode policy. Terminating the IoTS QSG now.");
            System.exit(0);
        }
        if (!(status = PolicyOperations.createPasscodePolicy("windows-passcode-policy1", "windows"))) {
            System.out.println("Unable to create the windows passcode policy. Terminating the IoTS QSG now.");
            System.exit(0);
        }
        System.out.println("Upload the android application ");
        MobileApplication application = AppOperations.uploadApplication("android", "con-app.apk", "application/vnd.android.package-archive");
        if (application == null) {
            System.out.println("Unable to upload the sample android application. Terminating the IoTS QSG now.");
            System.exit(0);
        }
        if ((application = AppOperations.uploadAssets("android", application)) == null) {
            System.out.println("Unable to upload the assets for sample android application. Terminating the IoTS QSG now.");
            System.exit(0);
        }
        System.out.println("Create the android application ");
        status = AppOperations.addApplication("WSO2Con-Android", application, true);
        if (!status) {
            System.out.println("Unable to create the android mobile application. Terminating the IoTS QSG now.");
            System.exit(0);
        }
        System.out.println("Upload the iOS application ");
        status = PolicyOperations.createPasscodePolicy("ios-passcode-policy1", "ios");
        if (!status) {
            System.out.println("Unable to create the ios passcode policy. Terminating the IoTS QSG now.");
            System.exit(0);
        }
        MobileApplication iOSApplication = AppOperations.uploadApplication("ios", "PNDemo.ipa", "application/octet-stream");
        iOSApplication.setVersion("1.0.0");
        iOSApplication = AppOperations.uploadAssets("ios", iOSApplication);
        if (iOSApplication == null) {
            System.out.println("Unable to upload the assets for sample iOS application. Terminating the IoTS QSG now.");
            System.exit(0);
        }
        System.out.println("Create the iOS application ");
        status = AppOperations.addApplication("WSO2Con-iOS", iOSApplication, true);
        if (!status) {
            System.out.println("Unable to create the iOS mobile application. Terminating the IoTS QSG now.");
            System.exit(0);
        }
        System.out.println("Exit");
    }
}

