/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.qsg.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.wso2.mdm.qsg.dto.HTTPResponse;

public class HTTPInvoker {
    private static final String OAUTH_BEARER = "Bearer ";
    public static String oAuthToken;

    private static HttpClient createHttpClient() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        HttpClientBuilder b = HttpClientBuilder.create();
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

            @Override
            public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                return true;
            }
        }).build();
        b.setSSLContext(sslContext);
        X509HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
        Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)sslSocketFactory)).build();
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        b.setConnectionManager(connMgr);
        CloseableHttpClient client = b.build();
        return client;
    }

    public static HTTPResponse sendHTTPPostWithURLParams(String url, List<NameValuePair> params, HashMap<String, String> headers) {
        HttpPost post = null;
        HttpResponse response = null;
        CloseableHttpClient httpclient = null;
        HTTPResponse httpResponse = new HTTPResponse();
        try {
            httpclient = (CloseableHttpClient)HTTPInvoker.createHttpClient();
            post = new HttpPost(url);
            post.setEntity(new UrlEncodedFormEntity(params));
            for (String key : headers.keySet()) {
                post.setHeader(key, headers.get(key));
            }
            response = httpclient.execute(post);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        BufferedReader rd = null;
        try {
            rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer result = new StringBuffer();
        String line = "";
        try {
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        httpResponse.setResponseCode(response.getStatusLine().getStatusCode());
        httpResponse.setResponse(result.toString());
        return httpResponse;
    }

    public static HTTPResponse sendHTTPPost(String url, String payload, HashMap<String, String> headers) {
        HttpPost post = null;
        HttpResponse response = null;
        HTTPResponse httpResponse = new HTTPResponse();
        CloseableHttpClient httpclient = null;
        try {
            httpclient = (CloseableHttpClient)HTTPInvoker.createHttpClient();
            StringEntity requestEntity = new StringEntity(payload, "utf-8");
            post = new HttpPost(url);
            post.setEntity(requestEntity);
            for (String key : headers.keySet()) {
                post.setHeader(key, headers.get(key));
            }
            response = httpclient.execute(post);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        BufferedReader rd = null;
        try {
            rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer result = new StringBuffer();
        String line = "";
        try {
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        httpResponse.setResponseCode(response.getStatusLine().getStatusCode());
        httpResponse.setResponse(result.toString());
        try {
            httpclient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return httpResponse;
    }

    public static HTTPResponse sendHTTPPutWithOAuthSecurity(String url, String payload, HashMap<String, String> headers) {
        HttpPut put = null;
        HttpResponse response = null;
        HTTPResponse httpResponse = new HTTPResponse();
        CloseableHttpClient httpclient = null;
        try {
            httpclient = (CloseableHttpClient)HTTPInvoker.createHttpClient();
            StringEntity requestEntity = new StringEntity(payload, "utf-8");
            put = new HttpPut(url);
            put.setEntity(requestEntity);
            for (String key : headers.keySet()) {
                put.setHeader(key, headers.get(key));
            }
            put.setHeader("Authorization", OAUTH_BEARER + oAuthToken);
            response = httpclient.execute(put);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        BufferedReader rd = null;
        try {
            rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer result = new StringBuffer();
        String line = "";
        try {
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        httpResponse.setResponseCode(response.getStatusLine().getStatusCode());
        httpResponse.setResponse(result.toString());
        try {
            httpclient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return httpResponse;
    }

    public static HTTPResponse sendHTTPPostWithOAuthSecurity(String url, String payload, HashMap<String, String> headers) {
        HttpPost post = null;
        HttpResponse response = null;
        HTTPResponse httpResponse = new HTTPResponse();
        CloseableHttpClient httpclient = null;
        try {
            httpclient = (CloseableHttpClient)HTTPInvoker.createHttpClient();
            StringEntity requestEntity = new StringEntity(payload, "utf-8");
            post = new HttpPost(url);
            post.setEntity(requestEntity);
            for (String key : headers.keySet()) {
                post.setHeader(key, headers.get(key));
            }
            post.setHeader("Authorization", OAUTH_BEARER + oAuthToken);
            response = httpclient.execute(post);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        BufferedReader rd = null;
        try {
            rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer result = new StringBuffer();
        String line = "";
        try {
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        httpResponse.setResponseCode(response.getStatusLine().getStatusCode());
        httpResponse.setResponse(result.toString());
        try {
            httpclient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return httpResponse;
    }

    public static HTTPResponse sendHTTPPostWithOAuthSecurity(String url, HttpEntity entity, HashMap<String, String> headers) {
        HttpPost post = null;
        HttpResponse response = null;
        HTTPResponse httpResponse = new HTTPResponse();
        CloseableHttpClient httpclient = null;
        try {
            httpclient = (CloseableHttpClient)HTTPInvoker.createHttpClient();
            post = new HttpPost(url);
            post.setEntity(entity);
            for (String key : headers.keySet()) {
                post.setHeader(key, headers.get(key));
            }
            post.setHeader("Authorization", OAUTH_BEARER + oAuthToken);
            response = httpclient.execute(post);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        BufferedReader rd = null;
        try {
            rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer result = new StringBuffer();
        String line = "";
        try {
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        httpResponse.setResponseCode(response.getStatusLine().getStatusCode());
        httpResponse.setResponse(result.toString());
        try {
            httpclient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return httpResponse;
    }

    public static HTTPResponse uploadFile(String url, String fileName, String fileContentType) {
        HttpPost post = null;
        HttpResponse response = null;
        HTTPResponse httpResponse = new HTTPResponse();
        CloseableHttpClient httpclient = null;
        try {
            httpclient = (CloseableHttpClient)HTTPInvoker.createHttpClient();
            post = new HttpPost(url);
            File file = new File(fileName);
            MultipartEntity mpEntity = new MultipartEntity();
            FileBody cbFile = new FileBody(file, fileContentType);
            mpEntity.addPart("file", cbFile);
            post.setEntity(mpEntity);
            post.setHeader("Authorization", OAUTH_BEARER + oAuthToken);
            post.setHeader("Accept", "application/json");
            response = httpclient.execute(post);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        BufferedReader rd = null;
        try {
            rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer result = new StringBuffer();
        String line = "";
        try {
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        httpResponse.setResponseCode(response.getStatusLine().getStatusCode());
        httpResponse.setResponse(result.toString());
        try {
            httpclient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return httpResponse;
    }
}

