/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.closure;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.WarningLevel;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.wso2.maven.closure.CompilableUnit;
import org.wso2.maven.closure.Definition;
import org.wso2.maven.closure.DefinitionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosureCompilerMojo
extends AbstractMojo {
    private static final String JS_SUFFIX = ".js";
    private static final String BASE_FILE_NAME = "base.js";
    private static final String FOR_NAME_METHOD_NAME = "forName";
    private String compilationLevel;
    private String warningLevel;
    private File[] externs;
    private String[] errors;
    private boolean manageDependencies;
    private boolean debug;
    private CompilableUnit[] compileUnits;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<JSSourceFile> externFiles = this.toSourceFiles(this.externs);
        for (CompilableUnit unit : this.compileUnits) {
            this.executeUnit(unit, externFiles);
        }
    }

    public void executeUnit(CompilableUnit unit, List<JSSourceFile> externFiles) throws MojoExecutionException, MojoFailureException {
        File[] inputs = unit.getInputs();
        File output = unit.getOutput();
        Compiler compiler = new Compiler();
        CompilerOptions compilerOptions = this.populateCompilerOptions(unit.getDefinitions());
        Result result = compiler.compile(externFiles, this.toSourceFiles(inputs), compilerOptions);
        for (JSError warning : result.warnings) {
            this.getLog().warn((CharSequence)warning.toString());
        }
        for (JSError error : result.errors) {
            this.getLog().error((CharSequence)error.toString());
        }
        if (!result.success) {
            throw new MojoFailureException("Compilation failure");
        }
        try {
            Files.createParentDirs((File)output);
            Files.touch((File)output);
            Files.write((CharSequence)compiler.toSource(), (File)output, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new MojoFailureException(output != null ? output.toString() : e.getMessage(), (Throwable)e);
        }
    }

    private CompilerOptions populateCompilerOptions(Definition[] definitions) throws MojoFailureException {
        CompilationLevel compilationLevel;
        WarningLevel warningLevel;
        CompilerOptions compilerOptions = new CompilerOptions();
        compilerOptions.closurePass = true;
        try {
            warningLevel = WarningLevel.valueOf((String)this.warningLevel);
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException("Unknown warning level", (Throwable)e);
        }
        warningLevel.setOptionsForWarningLevel(compilerOptions);
        try {
            compilationLevel = CompilationLevel.valueOf((String)this.compilationLevel);
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException("Unknown compilation level", (Throwable)e);
        }
        compilationLevel.setOptionsForCompilationLevel(compilerOptions);
        if (this.debug) {
            compilationLevel.setDebugOptionsForCompilationLevel(compilerOptions);
            compilerOptions.prettyPrint = true;
        } else {
            compilerOptions.setDefineToBooleanLiteral("goog.DEBUG", false);
        }
        if (definitions != null) {
            block16: for (Definition definition : definitions) {
                DefinitionType type = null;
                try {
                    type = DefinitionType.valueOf(definition.getType());
                }
                catch (Exception e) {
                    throw new MojoFailureException("Unknown definition type", (Throwable)e);
                }
                switch (type) {
                    case BOOLEAN: {
                        compilerOptions.setDefineToBooleanLiteral(definition.getName(), Boolean.parseBoolean(definition.getValue()));
                        continue block16;
                    }
                    case STRING: {
                        compilerOptions.setDefineToStringLiteral(definition.getName(), definition.getValue());
                        continue block16;
                    }
                    case DOUBLE: {
                        compilerOptions.setDefineToDoubleLiteral(definition.getName(), Double.parseDouble(definition.getValue()));
                        continue block16;
                    }
                }
            }
        }
        compilerOptions.setManageClosureDependencies(this.manageDependencies);
        Method forName = null;
        try {
            forName = DiagnosticGroups.class.getDeclaredMethod(FOR_NAME_METHOD_NAME, String.class);
            forName.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        DiagnosticGroups diagnosticGroups = new DiagnosticGroups();
        if (this.errors != null) {
            for (String error : this.errors) {
                try {
                    DiagnosticGroup group = (DiagnosticGroup)forName.invoke((Object)diagnosticGroups, error);
                    if (group == null) {
                        throw new MojoFailureException("Unknown diagnostic group " + error);
                    }
                    compilerOptions.setWarningLevel(group, CheckLevel.ERROR);
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
            }
        }
        return compilerOptions;
    }

    private List<JSSourceFile> toSourceFiles(File[] files) {
        ArrayList<JSSourceFile> sourceFiles = new ArrayList<JSSourceFile>();
        if (files != null) {
            for (File file : files) {
                this.addFiles(sourceFiles, file);
            }
        }
        return sourceFiles;
    }

    private void addFiles(List<JSSourceFile> jsSourceFiles, File file) {
        if (file != null) {
            if (file.isFile()) {
                String name = file.getName();
                if (name.endsWith(JS_SUFFIX)) {
                    JSSourceFile sourceFile = JSSourceFile.fromFile((File)file);
                    if (name.equalsIgnoreCase(BASE_FILE_NAME)) {
                        jsSourceFiles.add(0, sourceFile);
                    } else {
                        jsSourceFiles.add(sourceFile);
                    }
                }
            } else {
                File[] files = file.listFiles();
                if (files != null) {
                    for (File child : files) {
                        this.addFiles(jsSourceFiles, child);
                    }
                }
            }
        }
    }
}

