/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.bpel.artifact;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.wso2.maven.bpel.artifact.utils.FileUtils;

public class BPELMojo
extends AbstractMojo {
    private File path;
    private String type;
    private boolean enableArchive;
    private MavenProject mavenProject;
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File project = this.path;
        try {
            this.createZip(project);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createZip(File project) throws MojoExecutionException {
        try {
            String bpelArtifactFullPath = this.getBPELProjectName(project);
            File bpelArtifactFile = new File(bpelArtifactFullPath);
            String artifactType = this.getType();
            String artifactName = this.mavenProject.getArtifactId() + "." + artifactType;
            File archive = FileUtils.createArchive(project, bpelArtifactFile, artifactName);
            if (archive == null || !archive.exists()) {
                throw new MojoExecutionException(archive + " is null or doesn't exist");
            }
            this.mavenProject.getArtifact().setFile(archive);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while creating bpel archive", e);
        }
    }

    public String getBPELProjectName(File project) {
        List<File> fileList = FileUtils.getAllFilesPresentInFolder(project);
        String bpelProjectName = project.getName();
        for (int i = 0; i < fileList.size(); ++i) {
            File file = fileList.get(i);
            if (file.isDirectory()) continue;
            try {
                if (!file.getName().toLowerCase().endsWith(".bpel")) continue;
                bpelProjectName = file.getParent();
                return bpelProjectName;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return bpelProjectName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setEnableArchive(boolean enableArchive) {
        this.enableArchive = enableArchive;
    }

    public boolean isEnableArchive() {
        return this.enableArchive;
    }
}

