/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.bpel.artifact;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.FactoryConfigurationError;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.wso2.maven.capp.bundleartifact.AbstractBundlePOMGenMojo;
import org.wso2.maven.capp.model.Artifact;
import org.wso2.maven.capp.model.BundlesDataInfo;
import org.wso2.maven.capp.utils.CAppMavenUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPELPOMGenMojo
extends AbstractBundlePOMGenMojo {
    public MavenProject project;
    public MavenProjectHelper projectHelper;
    public File outputLocation;
    public File artifactLocation;
    public File moduleProject;
    public String groupId;
    public String typeList;
    private List<String> projects;
    public ArtifactFactory artifactFactory;
    public ArtifactResolver resolver;
    public ArtifactRepository localRepository;
    public List<?> remoteRepositories;
    private static final String ARTIFACT_TYPE = "bpel/workflow";
    private BundlesDataInfo bundlesDataInfo;
    private List<String> artifactProjects;

    protected String getArtifactType() {
        return ARTIFACT_TYPE;
    }

    protected List<String> getProjectMapStrings() {
        return this.projects;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public ArtifactResolver getResolver() {
        return this.resolver;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public List<?> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    protected String getBundleActivatorClass(Artifact artifact) {
        return null;
    }

    protected void addPlugins(MavenProject artifactMavenProject, Artifact artifact) {
        Plugin pluginAxis2 = CAppMavenUtils.createPluginEntry((MavenProject)artifactMavenProject, (String)"org.wso2.maven", (String)"maven-bpel-plugin", (String)"1.0.5", (boolean)true);
        PluginExecution executionAxis2 = new PluginExecution();
        executionAxis2.setId("package-bpel");
        executionAxis2.setPhase("package");
        ArrayList<String> goalsAxis2 = new ArrayList<String>();
        goalsAxis2.add("package-bpel");
        executionAxis2.setGoals(goalsAxis2);
        pluginAxis2.addExecution(executionAxis2);
        Xpp3Dom config = (Xpp3Dom)pluginAxis2.getConfiguration();
        Xpp3Dom artifactItems = CAppMavenUtils.createConfigurationNode((Xpp3Dom)config, (String)"artifact");
        String relativePath = artifact.getFile().getName();
        artifactItems.setValue(relativePath);
    }

    protected BundlesDataInfo getBundlesDataInfo(File targetProjectLocation, Artifact artifact) throws FactoryConfigurationError {
        if (this.bundlesDataInfo == null) {
            try {
                this.bundlesDataInfo = new BundlesDataInfo();
                this.bundlesDataInfo.setProjects(this.getProjectMappings());
                List<String> artifactProjects = this.getArtifactProjects();
                for (String artifactProject : artifactProjects) {
                    String[] projectNames;
                    String[] artifactProjectData = artifactProject.split(":");
                    if (artifactProjectData.length != 2 || !artifactProjectData[0].equals(artifact.getName())) continue;
                    for (String projectName : projectNames = artifactProjectData[1].split(",")) {
                        this.bundlesDataInfo.addProjectToList(projectName, null);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.bundlesDataInfo;
    }

    public List<String> getArtifactProjects() {
        if (this.artifactProjects == null) {
            this.artifactProjects = new ArrayList<String>();
        }
        return this.artifactProjects;
    }

    protected MavenProject createMavenProjectForCappArtifact(Artifact artifact, List<Artifact> artifacts, File projectLocation) throws MojoExecutionException {
        if (artifact.getFile().getPath().endsWith(".zip")) {
            MavenProject artifactMavenProject = CAppMavenUtils.createMavenProject((Artifact)artifact, (String)this.getGroupId(), (String)this.getArtifactType());
            this.addDependencies(artifactMavenProject, artifact, projectLocation);
            this.addPlugins(artifactMavenProject, artifact);
            this.addMavenDependencies(artifactMavenProject, artifact, artifacts);
            return artifactMavenProject;
        }
        return null;
    }

    protected void copyResources(MavenProject project, File projectLocation, Artifact artifact) throws IOException {
        super.copyResources(project, projectLocation, artifact);
        File bpelFileOriginal = artifact.getFile();
        File bpelFileDest = new File(projectLocation + File.separator + bpelFileOriginal.getName());
        FileUtils.copyFile((File)bpelFileOriginal, (File)bpelFileDest);
    }
}

