/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.bpel.artifact.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String src, String dest) {
        FileInputStream is = null;
        FileOutputStream fos = null;
        try {
            is = new FileInputStream(src);
            fos = new FileOutputStream(dest);
            int c = 0;
            byte[] array = new byte[1024];
            while ((c = ((InputStream)is).read(array)) >= 0) {
                fos.write(array, 0, c);
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdirs();
            }
            String[] children = srcDir.list();
            for (int i = 0; i < children.length; ++i) {
                FileUtils.copyDirectory(new File(srcDir, children[i]), new File(dstDir, children[i]));
            }
        } else {
            FileUtils.copy(srcDir, dstDir);
        }
    }

    public static void copyDirectoryContents(File srcDir, File dstDir) throws IOException {
        File[] listFiles;
        for (File srcFile : listFiles = srcDir.listFiles()) {
            if (srcFile.isDirectory()) {
                FileUtils.copyDirectory(srcFile, new File(dstDir, srcFile.getName()));
                continue;
            }
            FileUtils.copy(srcFile, new File(dstDir, srcFile.getName()));
        }
    }

    public static void copy(File src, File dst) throws IOException {
        int len;
        if (dst.getParentFile() != null && !dst.getParentFile().exists()) {
            dst.getParentFile().mkdirs();
        }
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static File createArchive(File location, File artifactLocation, String artifactName) throws Exception {
        List<File> allFilesPresentInFolder;
        String path = location.toString();
        List<File> bpelValidFileList = FileUtils.getBpelValidFileList(path, (allFilesPresentInFolder = FileUtils.getAllFilesPresentInFolder(new File(path))).toArray(new File[allFilesPresentInFolder.size()]));
        if (bpelValidFileList.size() == 0) {
            throw new Exception("The selected location " + location.getName() + "(" + location.toString() + ") does not contain any bpel processes.");
        }
        File targetFolder = null;
        targetFolder = new File(location.getPath(), "target");
        File bpelDataFolder = new File(targetFolder, "bpel-tmp");
        bpelDataFolder.mkdirs();
        File zipFolder = new File(bpelDataFolder, artifactLocation.getName());
        zipFolder.mkdirs();
        FileUtils.copyDirectory(artifactLocation, zipFolder, bpelValidFileList);
        FileUtils.removeEmptyDirectories(zipFolder);
        File zipFile = new File(targetFolder, artifactName);
        FileUtils.zipFolder(zipFolder.getAbsolutePath(), zipFile.toString());
        org.wso2.carbonstudio.eclipse.utils.file.FileUtils.deleteDir((File)bpelDataFolder);
        return zipFile;
    }

    public static File createTempFile() throws IOException {
        File tempFile = File.createTempFile("maven", ".tmp");
        return tempFile;
    }

    public static File createTempDirectory() throws IOException {
        File tempDirectory = FileUtils.createTempFile();
        tempDirectory.delete();
        tempDirectory.mkdirs();
        return tempDirectory;
    }

    public static List<File> getBpelValidFileList(String relativePath, File[] fileList) {
        ArrayList<File> list = new ArrayList<File>();
        ArrayList<File> existingWSDL = new ArrayList<File>();
        ArrayList<File> requiredWsdl = new ArrayList<File>();
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("pom.xml");
        excludeList.add("build.xml");
        excludeList.add(".project");
        excludeList.add(".classpath");
        excludeList.add(".svn");
        excludeList.add("target");
        excludeList.add(".settings");
        for (File file : fileList) {
            if (file.isDirectory()) continue;
            try {
                if (file.getName().toLowerCase().endsWith(".bpel") && FileUtils.isValidBPelFile(file, requiredWsdl)) {
                    list.add(file);
                    continue;
                }
                if (file.getName().toLowerCase().endsWith(".wsdl") && FileUtils.isValidWSDLFile(file)) {
                    existingWSDL.add(file);
                    continue;
                }
                if (excludeList.contains(file.getName()) || excludeList.contains(file.getParentFile().getName())) continue;
                list.add(file);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        List<String> compareList = FileUtils.getToStringList(requiredWsdl);
        for (File wsdlFileName : existingWSDL) {
            if (!compareList.contains(wsdlFileName.toString())) continue;
            list.add(wsdlFileName);
        }
        return list;
    }

    private static List<String> getToStringList(List<File> requiredWsdl) {
        ArrayList<String> resultStrings = new ArrayList<String>();
        for (File object : requiredWsdl) {
            resultStrings.add(((Object)object).toString());
        }
        return resultStrings;
    }

    public static boolean isValidDeployFile(File file) {
        Document xmlDocument = FileUtils.getXmlDocument(file);
        if (xmlDocument == null) {
            return false;
        }
        return xmlDocument.getDocumentElement().getNodeName().equalsIgnoreCase("deploy");
    }

    public static boolean isValidWSDLFile(File file) {
        return true;
    }

    public static boolean isValidXSDFile(File fileName) {
        return FileUtils.getXmlDocument(fileName) != null;
    }

    public static boolean isValidXSLTFile(File fileName) {
        return FileUtils.getXmlDocument(fileName) != null;
    }

    public static boolean isValidBPelFile(File file, List<File> wsdlList) throws IOException {
        Document xmlDocument = FileUtils.getXmlDocument(file);
        if (xmlDocument == null) {
            return false;
        }
        if (xmlDocument.getDocumentElement().getNodeName().toLowerCase().endsWith("process")) {
            NodeList childNodes = xmlDocument.getDocumentElement().getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node item = childNodes.item(i);
                if (!item.getNodeName().toLowerCase().endsWith("import")) continue;
                Node namedItem = item.getAttributes().getNamedItem("location");
                String nodeValue = namedItem.getNodeValue();
                File parentFile = file.getParentFile();
                File importedFile = new File(parentFile, nodeValue);
                wsdlList.add(importedFile.getCanonicalFile());
            }
            return true;
        }
        return false;
    }

    private static Document getXmlDocument(File file) {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(file);
            return doc;
        }
        catch (ParserConfigurationException e) {
            return null;
        }
        catch (SAXException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void copyDirectory(File srcPath, File dstPath, List<File> filesToBeCopied) throws IOException {
        List<String> pathStringList = FileUtils.getToStringList(filesToBeCopied);
        for (String string : pathStringList) {
            String path = string.substring(srcPath.getPath().length() + 1);
            File destFile = new File(dstPath, path);
            destFile.getParentFile().mkdirs();
            FileUtils.copy(new File(string), destFile);
        }
    }

    public static List<File> getAllFilesPresentInFolder(File srcPath) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (srcPath.isDirectory()) {
            String[] files = srcPath.list();
            for (int i = 0; i < files.length; ++i) {
                fileList.addAll(FileUtils.getAllFilesPresentInFolder(new File(srcPath, files[i])));
            }
        } else {
            fileList.add(srcPath);
        }
        return fileList;
    }

    public static void removeEmptyDirectories(File srcPath) {
        if (srcPath.isDirectory()) {
            String[] files = srcPath.list();
            for (int i = 0; i < files.length; ++i) {
                FileUtils.removeEmptyDirectories(new File(srcPath, files[i]));
            }
            if (srcPath.list().length == 0) {
                srcPath.delete();
            }
        }
    }

    public static void zipFolder(String srcFolder, String destZipFile) {
        ZipOutputStream zip = null;
        FileOutputStream fileWriter = null;
        try {
            fileWriter = new FileOutputStream(destZipFile);
            zip = new ZipOutputStream(fileWriter);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        FileUtils.addFolderContentsToZip(srcFolder, zip);
        try {
            zip.flush();
            zip.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void addToZip(String path, String srcFile, ZipOutputStream zip) {
        File folder = new File(srcFile);
        if (folder.isDirectory()) {
            FileUtils.addFolderToZip(path, srcFile, zip);
        } else {
            byte[] buf = new byte[1024];
            try {
                int len;
                FileInputStream in = new FileInputStream(srcFile);
                String nextEntryPath = path + File.separator + folder.getName();
                if (path != null && path.trim().equalsIgnoreCase("")) {
                    nextEntryPath = folder.getName();
                }
                zip.putNextEntry(new ZipEntry(nextEntryPath));
                while ((len = in.read(buf)) > 0) {
                    zip.write(buf, 0, len);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static void addFolderContentsToZip(String srcFolder, ZipOutputStream zip) {
        File folder = new File(srcFolder);
        String[] fileListe = folder.list();
        try {
            for (int i = 0; i <= fileListe.length; ++i) {
                FileUtils.addToZip("", srcFolder + File.separator + fileListe[i], zip);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private static void addFolderToZip(String path, String srcFolder, ZipOutputStream zip) {
        File folder = new File(srcFolder);
        String[] fileListe = folder.list();
        try {
            for (int i = 0; i <= fileListe.length; ++i) {
                String newPath = folder.getName();
                if (!path.equalsIgnoreCase("")) {
                    newPath = path + File.separator + newPath;
                }
                FileUtils.addToZip(newPath, srcFolder + File.separator + fileListe[i], zip);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }
}

