/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.car.artifact;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.wso2.carbonstudio.eclipse.utils.file.FileUtils;
import org.wso2.maven.capp.utils.CAppMavenUtils;
import org.wso2.maven.car.artifact.utils.CAppArtifact;
import org.wso2.maven.car.artifact.utils.CAppArtifactDependency;
import org.wso2.maven.car.artifact.utils.FileManagementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CARMojo
extends AbstractMojo {
    private File target;
    private File archiveLocation;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private ArtifactRepository localRepository;
    private List<?> remoteRepositories;
    private Map<String, CAppArtifactDependency> cAppArtifactDependencies = new HashMap<String, CAppArtifactDependency>();

    private void setupMavenRepoObjects() {
        CAppMavenUtils.setArtifactFactory((ArtifactFactory)this.artifactFactory);
        CAppMavenUtils.setResolver((ArtifactResolver)this.resolver);
        CAppMavenUtils.setLocalRepository((ArtifactRepository)this.localRepository);
        CAppMavenUtils.setRemoteRepositories(this.remoteRepositories);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setupMavenRepoObjects();
        CAppArtifact cAppArtifact = new CAppArtifact(this.project, null);
        this.collectArtifacts(cAppArtifact, this.cAppArtifactDependencies);
        try {
            cAppArtifact.setRoot(true);
            cAppArtifact.toFile(new File(this.getArchiveDir(), "artifacts.xml"));
            for (CAppArtifactDependency cAppDependency : this.cAppArtifactDependencies.values()) {
                cAppArtifact.setRoot(false);
                this.createArtifactData(this.getArchiveDir(), cAppDependency);
            }
            FileManagementUtil.zipFolder(this.getArchiveDir().toString(), this.getArchiveFile().toString());
            FileManagementUtil.deleteDirectories(this.getArchiveDir());
            this.project.getArtifact().setFile(this.getArchiveFile());
        }
        catch (Exception e) {
            throw new MojoExecutionException("", e);
        }
    }

    private void createArtifactData(File baseCARLocation, CAppArtifactDependency cAppArtifactDependency) throws IOException, MojoExecutionException {
        File artifactLocation = new File(baseCARLocation, cAppArtifactDependency.getName() + "_" + cAppArtifactDependency.getVersion());
        File[] cappArtifactFile = cAppArtifactDependency.getCappArtifactFile();
        File artifactFile = new File(artifactLocation, cAppArtifactDependency.getcAppArtifact().getFile());
        for (File file : cappArtifactFile) {
            if (file.isDirectory()) {
                FileUtils.copyDirectory((File)file, (File)new File(artifactLocation, file.getName()));
                continue;
            }
            FileUtils.copy((File)file, (File)new File(artifactLocation, file.getName()));
        }
        cAppArtifactDependency.getcAppArtifact().toFile(new File(artifactLocation, "artifact.xml"));
    }

    private void collectArtifacts(CAppArtifact cAppArtifact, Map<String, CAppArtifactDependency> cAppArtifacts) throws MojoExecutionException {
        List<CAppArtifactDependency> dependencies = cAppArtifact.getDependencies();
        for (CAppArtifactDependency artifactDependency : dependencies) {
            if (cAppArtifacts.containsKey(artifactDependency.getDependencyId())) continue;
            cAppArtifacts.put(artifactDependency.getDependencyId(), artifactDependency);
            this.collectArtifacts(artifactDependency.getcAppArtifact(), cAppArtifacts);
        }
    }

    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    public File getTarget() {
        return this.target;
    }

    private File getArchiveDir() {
        File archiveDir = new File(this.getTarget(), "car");
        if (!archiveDir.exists()) {
            archiveDir.mkdirs();
        }
        return archiveDir;
    }

    private File getArchiveFile() {
        File archiveFile = new File(this.getArchiveLocation(), this.project.getArtifactId() + "_" + this.project.getVersion() + ".car");
        return archiveFile;
    }

    public File getArchiveLocation() {
        return this.archiveLocation;
    }

    public void setArchiveLocation(File archiveLocation) {
        this.archiveLocation = archiveLocation;
    }
}

