/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.car.artifact.utils;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.wso2.carbonstudio.eclipse.utils.file.FileUtils;
import org.wso2.maven.capp.utils.CAppMavenUtils;
import org.wso2.maven.car.artifact.utils.CAppArtifact;

public class CAppArtifactDependency {
    private CAppArtifact cAppArtifact;
    private Dependency mavenDependency;

    public CAppArtifactDependency(Dependency mavenDependency, String serverRole) throws MojoExecutionException {
        this.setMavenDependency(mavenDependency);
        Artifact resolvedArtifactPom = CAppMavenUtils.getResolvedArtifactPom((Dependency)mavenDependency, (ArtifactFactory)CAppMavenUtils.getArtifactFactory(), (List)CAppMavenUtils.getRemoteRepositories(), (ArtifactRepository)CAppMavenUtils.getLocalRepository(), (ArtifactResolver)CAppMavenUtils.getResolver());
        MavenProject mavenProject = CAppMavenUtils.getMavenProject((File)resolvedArtifactPom.getFile());
        this.setcAppArtifact(new CAppArtifact(mavenProject, serverRole));
    }

    public CAppArtifactDependency(MavenProject project, String type, String serverRole) {
        this.setcAppArtifact(new CAppArtifact(project, serverRole));
        this.getMavenDependency().setType(type);
    }

    public String getDependencyId() {
        return this.cAppArtifact.getId();
    }

    public String getName() {
        return this.cAppArtifact.getName();
    }

    public String getVersion() {
        return this.cAppArtifact.getVersion();
    }

    private Dependency createMavenDependency() {
        Dependency mavenDependency = new Dependency();
        MavenProject project = this.cAppArtifact.getProject();
        mavenDependency.setGroupId(project.getGroupId());
        mavenDependency.setArtifactId(project.getArtifactId());
        mavenDependency.setVersion(project.getVersion());
        mavenDependency.setScope("capp");
        return mavenDependency;
    }

    public File[] getCappArtifactFile() throws MojoExecutionException, IOException {
        Artifact resolvedArtifact = CAppMavenUtils.getResolvedArtifact((Dependency)this.getMavenDependency(), (ArtifactFactory)CAppMavenUtils.getArtifactFactory(), (List)CAppMavenUtils.getRemoteRepositories(), (ArtifactRepository)CAppMavenUtils.getLocalRepository(), (ArtifactResolver)CAppMavenUtils.getResolver(), (String)"capp");
        File mavenArtifact = resolvedArtifact.getFile();
        String[] split = mavenArtifact.getName().split("\\.");
        if (this.getcAppArtifact().getType().equals("registry/resource")) {
            File[] listFiles;
            File tempDirectory = FileUtils.createTempDirectory();
            FileUtils.extract((File)mavenArtifact, (File)tempDirectory);
            for (File file : listFiles = tempDirectory.listFiles()) {
                if (!file.isFile() || !file.getName().toLowerCase().endsWith(".xml")) continue;
                this.getcAppArtifact().setFile(file.getName());
            }
            return listFiles;
        }
        this.getcAppArtifact().setFile(mavenArtifact.getName());
        return new File[]{mavenArtifact};
    }

    public String toString() {
        return this.getCaption();
    }

    public String getCaption() {
        return this.getName() + " - " + this.getVersion();
    }

    public String getType() {
        return this.getMavenDependency().getType();
    }

    private void setcAppArtifact(CAppArtifact cAppArtifact) {
        this.cAppArtifact = cAppArtifact;
    }

    public CAppArtifact getcAppArtifact() {
        return this.cAppArtifact;
    }

    public String getServerRole() {
        return this.cAppArtifact.getServerRole();
    }

    public Dependency getMavenDependency() {
        if (this.mavenDependency == null) {
            this.mavenDependency = this.createMavenDependency();
        }
        return this.mavenDependency;
    }

    public void setMavenDependency(Dependency mavenDependency) {
        this.mavenDependency = mavenDependency;
    }
}

