/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.car.artifact;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.wso2.developerstudio.eclipse.utils.file.FileUtils;
import org.wso2.maven.capp.model.CAppArtifact;
import org.wso2.maven.capp.model.CAppArtifactDependency;
import org.wso2.maven.capp.utils.CAppMavenUtils;
import org.wso2.maven.car.artifact.utils.FileManagementUtil;
import org.wso2.maven.plugin.synapse.utils.SynapseArtifactBundleCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CARMojo
extends AbstractMojo {
    private File target;
    private File archiveLocation;
    public String finalName;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private ArtifactRepository localRepository;
    private List<?> remoteRepositories;
    private Map<String, CAppArtifactDependency> cAppArtifactDependencies = new HashMap<String, CAppArtifactDependency>();

    private void setupMavenRepoObjects() {
        CAppMavenUtils.setArtifactFactory((ArtifactFactory)this.artifactFactory);
        CAppMavenUtils.setResolver((ArtifactResolver)this.resolver);
        CAppMavenUtils.setLocalRepository((ArtifactRepository)this.localRepository);
        CAppMavenUtils.setRemoteRepositories(this.remoteRepositories);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setupMavenRepoObjects();
        CAppArtifact cAppArtifact = new CAppArtifact(this.project, null);
        this.collectArtifacts(cAppArtifact, this.cAppArtifactDependencies);
        try {
            cAppArtifact.setRoot(true);
            cAppArtifact.toFile(new File(this.getArchiveDir(), "artifacts.xml"));
            for (CAppArtifactDependency cAppDependency : this.cAppArtifactDependencies.values()) {
                cAppArtifact.setRoot(false);
                this.createArtifactData(this.getArchiveDir(), cAppDependency);
            }
            FileManagementUtil.zipFolder(this.getArchiveDir().toString(), this.getArchiveFile().toString());
            FileManagementUtil.deleteDirectories(this.getArchiveDir());
            this.project.getArtifact().setFile(this.getArchiveFile());
        }
        catch (Exception e) {
            throw new MojoExecutionException("", e);
        }
    }

    private void createArtifactData(File baseCARLocation, CAppArtifactDependency cAppArtifactDependency) throws IOException, MojoExecutionException {
        File[] cappArtifactFile;
        File artifactLocation = new File(baseCARLocation, cAppArtifactDependency.getName() + "_" + cAppArtifactDependency.getVersion());
        for (File file : cappArtifactFile = cAppArtifactDependency.getCappArtifactFile()) {
            if (file.isDirectory()) {
                FileUtils.copyDirectory((File)file, (File)new File(artifactLocation, file.getName()));
                continue;
            }
            FileUtils.copy((File)file, (File)new File(artifactLocation, file.getName()));
        }
        cAppArtifactDependency.getcAppArtifact().toFile(new File(artifactLocation, "artifact.xml"));
    }

    private void collectArtifacts(CAppArtifact cAppArtifact, Map<String, CAppArtifactDependency> cAppArtifacts) throws MojoExecutionException {
        List dependencies = cAppArtifact.getDependencies();
        cAppArtifact.getDependencies().clear();
        for (CAppArtifactDependency artifactDependency : dependencies) {
            if (cAppArtifacts.containsKey(artifactDependency.getDependencyId())) continue;
            List<CAppArtifactDependency> artifactsToAdd = this.processArtifactsToAdd(artifactDependency);
            boolean originalDependencyPresent = false;
            for (CAppArtifactDependency cAppArtifactDependency : artifactsToAdd) {
                cAppArtifact.addDependencies(cAppArtifactDependency);
                cAppArtifacts.put(cAppArtifactDependency.getDependencyId(), cAppArtifactDependency);
                this.collectArtifacts(cAppArtifactDependency.getcAppArtifact(), cAppArtifacts);
                originalDependencyPresent = originalDependencyPresent || artifactDependency.getName().equals(cAppArtifactDependency.getName()) && artifactDependency.getVersion().equals(cAppArtifactDependency.getVersion());
            }
            if (originalDependencyPresent) continue;
            cAppArtifact.addIgnoreDependency(artifactDependency);
        }
    }

    private List<CAppArtifactDependency> processArtifactsToAdd(CAppArtifactDependency artifactDependency) throws MojoExecutionException {
        List<Object> artifactsToAdd = new ArrayList<CAppArtifactDependency>();
        try {
            if (artifactDependency.getcAppArtifact().getProject().getPackaging().equals("synapse/configuration")) {
                SynapseArtifactBundleCreator synapseArtifactBundleCreator = new SynapseArtifactBundleCreator(artifactDependency);
                artifactsToAdd = synapseArtifactBundleCreator.exportDependentArtifacts(artifactDependency.getCappArtifactFile()[0], artifactDependency);
            } else {
                artifactsToAdd.add(artifactDependency);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error occured while processing artifact", e);
        }
        return artifactsToAdd;
    }

    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    public File getTarget() {
        return this.target;
    }

    private File getArchiveDir() {
        File archiveDir = new File(this.getTarget(), "car");
        if (!archiveDir.exists()) {
            archiveDir.mkdirs();
        }
        return archiveDir;
    }

    private File getArchiveFile() {
        File archiveFile = new File(this.getArchiveLocation(), this.project.getArtifactId() + "_" + this.project.getVersion() + ".car");
        if (this.finalName != null && !this.finalName.trim().equals("")) {
            archiveFile = new File(this.getArchiveLocation(), this.finalName + ".car");
        }
        return archiveFile;
    }

    public File getArchiveLocation() {
        return this.archiveLocation;
    }

    public void setArchiveLocation(File archiveLocation) {
        this.archiveLocation = archiveLocation;
    }
}

