/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.car.artifact;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.wso2.developerstudio.eclipse.utils.archive.ArchiveManipulator;
import org.wso2.developerstudio.eclipse.utils.file.FileUtils;
import org.wso2.maven.capp.utils.CAppMavenUtils;
import org.wso2.maven.car.artifact.CARMavenArtifact;
import org.wso2.maven.car.artifact.fsm.TopologyFSEngine;
import org.wso2.maven.car.artifact.fsm.resolvers.ServerParameterResolver;
import org.wso2.maven.car.artifact.utils.FileManagementUtil;
import org.wso2.maven.stratos.exception.UnsupportedTopologyVersion;
import org.wso2.maven.stratos.interfaces.ITopology;
import org.wso2.maven.stratos.model.TopologyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CARMojo2
extends AbstractMojo {
    private CARMavenArtifact car;
    private CARMavenArtifact topology;
    private Boolean failOnMissingParameters;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private ArtifactRepository localRepository;
    private List<?> remoteRepositories;
    private static String[] scanExtensions = new String[]{"xml", "txt", "properties", "wsdl"};
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<File, List<String>> fileParameters = new HashMap<File, List<String>>();
    private List<File> scanedFiles = new ArrayList<File>();

    private void setupMavenRepoObjects() {
        CAppMavenUtils.setArtifactFactory((ArtifactFactory)this.artifactFactory);
        CAppMavenUtils.setResolver((ArtifactResolver)this.resolver);
        CAppMavenUtils.setLocalRepository((ArtifactRepository)this.localRepository);
        CAppMavenUtils.setRemoteRepositories(this.remoteRepositories);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setupMavenRepoObjects();
        File carFile = this.getCARFile();
        File topologyFile = this.getTopologyFile();
        try {
            File tempCARDirectory = this.extractCAR(carFile);
            this.retrieveParameters(tempCARDirectory);
            this.resolveParameters(topologyFile);
            this.updateFiles(tempCARDirectory);
            File rebuiltCARFile = this.rebuildCAR(tempCARDirectory);
            this.project.getArtifact().setFile(rebuiltCARFile);
            this.lineBreak();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error trying to rebuild the CAR:" + e.getLocalizedMessage(), e);
        }
    }

    private File extractCAR(File carFile) throws IOException {
        File tempCARDirectory = new File(this.project.getBuild().getDirectory(), "car.tmp");
        new ArchiveManipulator().extract(carFile, tempCARDirectory);
        return tempCARDirectory;
    }

    private File rebuildCAR(File tempCARDirectory) {
        this.lineBreak();
        this.getLog().info((CharSequence)"Building the new CAR...");
        File rebuiltCARFile = new File(this.project.getBuild().getDirectory(), this.project.getArtifactId() + ".car");
        rebuiltCARFile.getParentFile().mkdirs();
        FileManagementUtil.zipFolder(tempCARDirectory.toString(), rebuiltCARFile.toString());
        this.getProjectHelper().attachArtifact(this.project, "car", rebuiltCARFile);
        return rebuiltCARFile;
    }

    private void updateFiles(File tempCARDirectory) throws IOException {
        this.lineBreak();
        this.getLog().info((CharSequence)"Replacing parameters...");
        for (File scannedFile : this.scanedFiles) {
            List<String> fileParameterList = this.getFileParameters(scannedFile);
            if (fileParameterList.size() <= 0) continue;
            this.getLog().info((CharSequence)("\t" + FileUtils.getRelativePath((File)tempCARDirectory, (File)scannedFile)));
            String content = FileUtils.getContentAsString((File)scannedFile);
            content = this.replaceParameters(content, fileParameterList, this.parameters);
            FileUtils.writeContent((File)scannedFile, (String)content);
        }
    }

    private void retrieveParameters(File tempCARDirectory) throws IOException {
        this.lineBreak();
        this.getLog().info((CharSequence)"Scanning the carbon application archive");
        this.getLog().info((CharSequence)"\tmatching file...");
        this.scanForFiles(tempCARDirectory, this.scanedFiles);
        this.getLog().info((CharSequence)"\tparameters...");
        this.checkForParametes(this.scanedFiles);
    }

    private void resolveParameters(File topologyFile) throws UnsupportedTopologyVersion, MojoExecutionException {
        this.lineBreak();
        this.getLog().info((CharSequence)"Resolving parameters...");
        ITopology topology = TopologyFactory.createNewTopology((File)topologyFile);
        TopologyFSEngine engine = new TopologyFSEngine(topology, this.getParameters());
        this.registerResolvers(engine);
        engine.execute();
        this.setParameters(engine.getParameters());
        this.processUnresolvedParameters();
    }

    private void registerResolvers(TopologyFSEngine engine) {
        engine.registerResolver(new ServerParameterResolver());
    }

    private void lineBreak() {
        this.getLog().info((CharSequence)"");
    }

    private void processUnresolvedParameters() throws MojoExecutionException {
        boolean missingFound = false;
        for (String parameter : this.parameters.keySet()) {
            if (this.parameters.get(parameter) != null) continue;
            missingFound = true;
            String paraMissingMsg = "\tUnable to resolve parameter '" + parameter + "'";
            if (this.isFailOnMissingParameters()) {
                this.getLog().error((CharSequence)paraMissingMsg);
                continue;
            }
            this.getLog().warn((CharSequence)paraMissingMsg);
        }
        if (this.isFailOnMissingParameters() && missingFound) {
            throw new MojoExecutionException("Not all parameters were resolved");
        }
    }

    private File getCARFile() throws MojoExecutionException {
        Artifact carArtifact = CAppMavenUtils.getResolvedArtifact((String)this.getCar().getGroupId(), (String)this.getCar().getArtifactId(), (String)this.getCar().getVersion(), (String)"car", null);
        File carFile = carArtifact.getFile();
        return carFile;
    }

    private File getTopologyFile() throws MojoExecutionException {
        Artifact topologyArtifact = CAppMavenUtils.getResolvedArtifact((String)this.getTopology().getGroupId(), (String)this.getTopology().getArtifactId(), (String)this.getTopology().getVersion(), (String)"xml", null);
        File topologyFile = topologyArtifact.getFile();
        return topologyFile;
    }

    private String replaceParameters(String content, List<String> parametersPresent, Map<String, String> allParameters) {
        for (String parameter : parametersPresent) {
            if (!allParameters.containsKey(parameter)) continue;
            String parameterValue = allParameters.get(parameter);
            if (parameterValue == null) {
                this.getLog().warn((CharSequence)("\t\t" + parameter + " NOT RESOLVED"));
                continue;
            }
            this.getLog().info((CharSequence)("\t\t" + parameter + " - " + parameterValue));
            String parameterRegEx = Pattern.quote(parameter);
            Pattern compile = Pattern.compile(parameterRegEx);
            Matcher matcher = compile.matcher(content);
            while (matcher.find()) {
                content = matcher.replaceAll(parameterValue);
            }
        }
        return content;
    }

    private void checkForParametes(List<File> scanedFiles) throws IOException {
        String parameterRegEx = Pattern.quote("${") + "[^" + Pattern.quote("$") + "]*" + Pattern.quote("}");
        Pattern compile = Pattern.compile(parameterRegEx);
        for (File scannedFile : scanedFiles) {
            String content = FileUtils.getContentAsString((File)scannedFile);
            Matcher matcher = compile.matcher(content);
            List<String> fileParametersList = this.getFileParameters(scannedFile);
            while (matcher.find()) {
                MatchResult matchResult = matcher.toMatchResult();
                if (fileParametersList.contains(matchResult.group())) continue;
                fileParametersList.add(matchResult.group());
                this.getParameters().put(matchResult.group(), null);
            }
        }
    }

    private void scanForFiles(File tempCARDirectory, List<File> scanedFiles) {
        File[] files;
        for (File candiate : files = tempCARDirectory.listFiles()) {
            if (candiate.isFile() && this.containsExtension(candiate)) {
                scanedFiles.add(candiate);
                continue;
            }
            if (!candiate.isDirectory()) continue;
            this.scanForFiles(candiate, scanedFiles);
        }
    }

    private boolean containsExtension(File candiate) {
        boolean isType = false;
        for (String extension : CARMojo2.getScanExtensions()) {
            if (!candiate.getName().toLowerCase().endsWith("." + extension)) continue;
            isType = true;
            break;
        }
        return isType;
    }

    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public static String[] getScanExtensions() {
        return scanExtensions;
    }

    public void setFileParameters(Map<File, List<String>> fileParameters) {
        this.fileParameters = fileParameters;
    }

    public Map<File, List<String>> getFileParameters() {
        return this.fileParameters;
    }

    public List<String> getFileParameters(File file) {
        if (!this.getFileParameters().containsKey(file)) {
            this.getFileParameters().put(file, new ArrayList());
        }
        return this.getFileParameters().get(file);
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setCar(CARMavenArtifact car) {
        this.car = car;
    }

    public CARMavenArtifact getCar() {
        return this.car;
    }

    public void setTopology(CARMavenArtifact topology) {
        this.topology = topology;
    }

    public CARMavenArtifact getTopology() {
        return this.topology;
    }

    public boolean isFailOnMissingParameters() {
        if (this.failOnMissingParameters == null) {
            this.failOnMissingParameters = System.getProperty("failOnMissingParameters") != null ? Boolean.valueOf(System.getProperty("failOnMissingParameters").toLowerCase().equals("true")) : Boolean.valueOf(false);
        }
        return this.failOnMissingParameters;
    }
}

