/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.car.artifact;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.wso2.developerstudio.eclipse.utils.file.FileUtils;
import org.wso2.maven.capp.model.CAppArtifact;
import org.wso2.maven.capp.model.CAppArtifactDependency;
import org.wso2.maven.capp.utils.CAppMavenUtils;
import org.wso2.maven.car.artifact.artifact;
import org.wso2.maven.car.artifact.utils.FileManagementUtil;
import org.wso2.maven.plugin.synapse.utils.SynapseArtifactBundleCreator;

public class CARMojo
extends AbstractMojo {
    private static final String METADATA_ARTIFACT_TYPE = "synapse/metadata";
    private static final String METADATA_FOLDER_NAME = "metadata";
    private static final String METADATA_FILE_NAME = "metadata.xml";
    private static final String ARTIFACTS_FILE_NAME = "artifacts.xml";
    private File target;
    private File archiveLocation;
    public String finalName;
    public String classifier;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private ArtifactRepository localRepository;
    private List<?> remoteRepositories;
    private List<artifact> artifacts;
    private Map<String, CAppArtifactDependency> cAppArtifactDependencies = new HashMap<String, CAppArtifactDependency>();

    private void setupMavenRepoObjects() {
        CAppMavenUtils.setArtifactFactory((ArtifactFactory)this.artifactFactory);
        CAppMavenUtils.setResolver((ArtifactResolver)this.resolver);
        CAppMavenUtils.setLocalRepository((ArtifactRepository)this.localRepository);
        CAppMavenUtils.setRemoteRepositories(this.remoteRepositories);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setupMavenRepoObjects();
        CAppArtifact cAppArtifact = new CAppArtifact(this.project, null);
        this.collectArtifacts(cAppArtifact, this.cAppArtifactDependencies);
        try {
            cAppArtifact.setRoot(true);
            cAppArtifact.toFile(new File(this.getArchiveDir(), METADATA_FILE_NAME));
            cAppArtifact.getDependencies().removeIf(c -> METADATA_ARTIFACT_TYPE.equals(c.getcAppArtifact().getType()));
            cAppArtifact.toFile(new File(this.getArchiveDir(), ARTIFACTS_FILE_NAME));
            for (CAppArtifactDependency cAppDependency : this.cAppArtifactDependencies.values()) {
                cAppArtifact.setRoot(false);
                this.createArtifactData(this.getArchiveDir(), cAppDependency);
            }
            FileManagementUtil.zipFolder(this.getArchiveDir().toString(), this.getArchiveFile().toString());
            FileManagementUtil.deleteDirectories(this.getArchiveDir());
            this.project.getArtifact().setFile(this.getArchiveFile());
        }
        catch (Exception e) {
            throw new MojoExecutionException("", e);
        }
    }

    private void createArtifactData(File baseCARLocation, CAppArtifactDependency cAppArtifactDependency) throws IOException, MojoExecutionException {
        File[] cappArtifactFile;
        this.getLog().info((CharSequence)("Generating artifact descriptor for artifact: " + cAppArtifactDependency.getName()));
        if (cAppArtifactDependency.getcAppArtifact().getType() != null && cAppArtifactDependency.getcAppArtifact().getType().equals(METADATA_ARTIFACT_TYPE)) {
            baseCARLocation = new File(baseCARLocation, METADATA_FOLDER_NAME);
        }
        File artifactLocation = new File(baseCARLocation, cAppArtifactDependency.getName() + "_" + cAppArtifactDependency.getVersion());
        CAppArtifact cAppArtifact = cAppArtifactDependency.getcAppArtifact();
        Dependency mavenArtifact = cAppArtifactDependency.getMavenDependency();
        String artifactFinalName = null;
        if (this.artifacts != null) {
            for (artifact cappArtifact : this.artifacts) {
                if (!mavenArtifact.getGroupId().equals(cappArtifact.getGroupId()) || !mavenArtifact.getArtifactId().equals(cappArtifact.getArtifactId())) continue;
                artifactFinalName = cappArtifact.getFinalName();
                break;
            }
        }
        this.getLog().info((CharSequence)"Copying artifact content to target location.");
        for (File file : cappArtifactFile = cAppArtifactDependency.getCappArtifactFile()) {
            if (file.isDirectory()) {
                FileUtils.copyDirectory((File)file, (File)new File(artifactLocation, file.getName()));
                continue;
            }
            if (artifactFinalName == null) {
                FileUtils.copy((File)file, (File)new File(artifactLocation, file.getName()));
                continue;
            }
            FileUtils.copy((File)file, (File)new File(artifactLocation, artifactFinalName));
            cAppArtifact.setFile(artifactFinalName);
        }
        cAppArtifact.toFile(new File(artifactLocation, "artifact.xml"));
    }

    private void collectArtifacts(CAppArtifact cAppArtifact, Map<String, CAppArtifactDependency> cAppArtifacts) throws MojoExecutionException {
        List dependencies = cAppArtifact.getDependencies();
        for (CAppArtifactDependency artifactDependency : dependencies) {
            if (cAppArtifacts.containsKey(artifactDependency.getDependencyId())) continue;
            List<CAppArtifactDependency> artifactsToAdd = this.processArtifactsToAdd(artifactDependency);
            boolean originalDependencyPresent = false;
            for (CAppArtifactDependency cAppArtifactDependency : artifactsToAdd) {
                cAppArtifact.addDependencies(cAppArtifactDependency);
                cAppArtifacts.put(cAppArtifactDependency.getDependencyId(), cAppArtifactDependency);
                this.collectArtifacts(cAppArtifactDependency.getcAppArtifact(), cAppArtifacts);
                originalDependencyPresent = originalDependencyPresent || artifactDependency.getName().equals(cAppArtifactDependency.getName()) && artifactDependency.getVersion().equals(cAppArtifactDependency.getVersion());
            }
            if (originalDependencyPresent) continue;
            cAppArtifact.addIgnoreDependency(artifactDependency);
        }
    }

    private List<CAppArtifactDependency> processArtifactsToAdd(CAppArtifactDependency artifactDependency) throws MojoExecutionException {
        List<Object> artifactsToAdd = new ArrayList<CAppArtifactDependency>();
        try {
            if (artifactDependency.getcAppArtifact().getProject().getPackaging().equals("synapse/configuration")) {
                SynapseArtifactBundleCreator synapseArtifactBundleCreator = new SynapseArtifactBundleCreator(artifactDependency);
                artifactsToAdd = synapseArtifactBundleCreator.exportDependentArtifacts(artifactDependency.getCappArtifactFile()[0], artifactDependency);
            } else {
                artifactsToAdd.add(artifactDependency);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error occured while processing artifact", e);
        }
        return artifactsToAdd;
    }

    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    public File getTarget() {
        return this.target;
    }

    private File getArchiveDir() {
        File archiveDir = new File(this.getTarget(), "car");
        if (!archiveDir.exists()) {
            archiveDir.mkdirs();
        }
        return archiveDir;
    }

    private File getArchiveFile() {
        String archiveFilename = this.project.getArtifactId() + "_" + this.project.getVersion() + (this.classifier != null ? "-" + this.classifier : "") + ".car";
        File archiveFile = new File(this.getArchiveLocation(), archiveFilename);
        if (this.finalName != null && !this.finalName.trim().equals("")) {
            archiveFile = new File(this.getArchiveLocation(), this.finalName + ".car");
        }
        return archiveFile;
    }

    public File getArchiveLocation() {
        return this.archiveLocation;
    }

    public void setArchiveLocation(File archiveLocation) {
        this.archiveLocation = archiveLocation;
    }
}

