/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.plugin.jaxws;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.stream.FactoryConfigurationError;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.wso2.maven.capp.model.Artifact;
import org.wso2.maven.capp.model.BundlesDataInfo;
import org.wso2.maven.capp.model.ProjectMapping;
import org.wso2.maven.capp.mojo.AbstractPOMGenMojo;
import org.wso2.maven.capp.utils.CAppMavenUtils;
import org.wso2.maven.core.utils.MavenUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWSPOMGenMojo
extends AbstractPOMGenMojo {
    public MavenProject project;
    public MavenProjectHelper projectHelper;
    public File outputLocation;
    public File artifactLocation;
    public File moduleProject;
    public String groupId;
    public String typeList;
    private List<String> projects;
    private List<String> artifactProjects;
    private static final String ARTIFACT_TYPE = "service/jaxws";
    private BundlesDataInfo bundlesDataInfo;

    protected BundlesDataInfo getBundlesDataInfo(File targetProjectLocation, Artifact artifact) throws FactoryConfigurationError {
        if (this.bundlesDataInfo == null) {
            try {
                this.bundlesDataInfo = new BundlesDataInfo();
                this.bundlesDataInfo.setProjects(this.getProjectMappings());
                List<String> artifactProjects = this.getArtifactProjects();
                for (String artifactProject : artifactProjects) {
                    String[] projectNames;
                    String[] artifactProjectData = artifactProject.split(":");
                    if (artifactProjectData.length != 2 || !artifactProjectData[0].equals(artifact.getName())) continue;
                    for (String projectName : projectNames = artifactProjectData[1].split(",")) {
                        this.bundlesDataInfo.addProjectToList(projectName, null);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.bundlesDataInfo;
    }

    protected List<String> getProjectMapStrings() {
        return this.projects;
    }

    public List<String> getArtifactProjects() {
        if (this.artifactProjects == null) {
            this.artifactProjects = new ArrayList<String>();
        }
        return this.artifactProjects;
    }

    protected List<ProjectMapping> getProjectMappings() throws Exception {
        List<String> projects = this.getProjectMapStrings();
        ArrayList<ProjectMapping> projectMappings = new ArrayList<ProjectMapping>();
        if (projects != null) {
            for (String project : projects) {
                projectMappings.add(ProjectMapping.getMapping((String)project));
            }
        }
        return projectMappings;
    }

    protected void copyResources(MavenProject project, File projectLocation, Artifact artifact) throws IOException {
        File jaxWSArtifact = artifact.getFile();
        FileUtils.copyFile((File)jaxWSArtifact, (File)new File(projectLocation, jaxWSArtifact.getName()));
    }

    protected void addPlugins(MavenProject artifactMavenProject, Artifact artifact) {
        if (artifact.getFile().getPath().endsWith(".jar")) {
            Plugin plugin = CAppMavenUtils.createPluginEntry((MavenProject)artifactMavenProject, (String)"org.wso2.maven", (String)"maven-jaxws-plugin", (String)"2.0.0", (boolean)true);
            Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
            Xpp3Dom aritfact = CAppMavenUtils.createConfigurationNode((Xpp3Dom)configuration, (String)"artifact");
            aritfact.setValue(artifact.getFile().getName());
        } else {
            artifactMavenProject.setPackaging("jar");
            artifactMavenProject.getModel().addProperty("CApp.type", this.getArtifactType());
            this.getLog().info((CharSequence)"Adding JAXWS reated plugins");
            Plugin plugin = CAppMavenUtils.createPluginEntry((MavenProject)artifactMavenProject, (String)"org.apache.maven.plugins", (String)"maven-dependency-plugin", (String)"2.2", (boolean)true);
            PluginExecution execution = new PluginExecution();
            execution.setId("unpack");
            execution.setPhase("package");
            ArrayList<String> goals = new ArrayList<String>();
            goals.add("unpack");
            execution.setGoals(goals);
            plugin.addExecution(execution);
            Xpp3Dom config = (Xpp3Dom)plugin.getConfiguration();
            Xpp3Dom artifactItems = CAppMavenUtils.createConfigurationNode((Xpp3Dom)config, (String)"artifactItems");
            Xpp3Dom artifactItem = CAppMavenUtils.createConfigurationNode((Xpp3Dom)artifactItems, (String)"artifactItem");
            String serviceProject = null;
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(artifact.getFile()));
                serviceProject = properties.getProperty("Projects");
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                List<ProjectMapping> projectMappings = this.getProjectMappings();
                for (int i = 0; i < projectMappings.size(); ++i) {
                    ProjectMapping projectMapping = projectMappings.get(i);
                    if (!projectMapping.projectName.equalsIgnoreCase(serviceProject)) continue;
                    Xpp3Dom groupId = CAppMavenUtils.createConfigurationNode((Xpp3Dom)artifactItem, (String)"groupId");
                    groupId.setValue(projectMapping.getGroupId());
                    Xpp3Dom artifactId = CAppMavenUtils.createConfigurationNode((Xpp3Dom)artifactItem, (String)"artifactId");
                    artifactId.setValue(projectMapping.getArtifactId());
                    Xpp3Dom version = CAppMavenUtils.createConfigurationNode((Xpp3Dom)artifactItem, (String)"version");
                    version.setValue(projectMapping.getVersion());
                    Xpp3Dom type = CAppMavenUtils.createConfigurationNode((Xpp3Dom)artifactItem, (String)"type");
                    type.setValue("jar");
                    Xpp3Dom overWrite = CAppMavenUtils.createConfigurationNode((Xpp3Dom)artifactItem, (String)"overWrite");
                    overWrite.setValue("true");
                    Xpp3Dom outputDirectory = CAppMavenUtils.createConfigurationNode((Xpp3Dom)artifactItem, (String)"outputDirectory");
                    outputDirectory.setValue("target" + File.separator + "jar");
                }
            }
            catch (Exception e) {
                this.getLog().error((Throwable)e);
            }
            Plugin pluginJaxWs = CAppMavenUtils.createPluginEntry((MavenProject)artifactMavenProject, (String)"org.apache.maven.plugins", (String)"maven-jar-plugin", (String)"2.3.1", (boolean)true);
            PluginExecution executionJaxWs = new PluginExecution();
            executionJaxWs.setId("jar");
            executionJaxWs.setPhase("package");
            ArrayList<String> goalsJaxWs = new ArrayList<String>();
            goalsJaxWs.add("jar");
            executionJaxWs.setGoals(goalsJaxWs);
            Xpp3Dom mainNode = MavenUtils.createMainConfigurationNode();
            pluginJaxWs.setConfiguration((Object)mainNode);
            Xpp3Dom classDirNode = MavenUtils.createConfigurationNode((Xpp3Dom)mainNode, (String)"classesDirectory");
            classDirNode.setValue("target" + File.separator + "jar");
            Xpp3Dom includes = MavenUtils.createConfigurationNode((Xpp3Dom)mainNode, (String)"includes");
            Xpp3Dom include = MavenUtils.createConfigurationNode((Xpp3Dom)includes, (String)"include");
            include.setValue("**/*.class");
            Xpp3Dom forceCreation = MavenUtils.createConfigurationNode((Xpp3Dom)mainNode, (String)"forceCreation");
            forceCreation.setValue("true");
            pluginJaxWs.setConfiguration((Object)mainNode);
            pluginJaxWs.addExecution(executionJaxWs);
        }
    }

    protected String getArtifactType() {
        return ARTIFACT_TYPE;
    }
}

