/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.registry;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.wso2.carbonstudio.eclipse.utils.archive.ArchiveManipulator;
import org.wso2.carbonstudio.eclipse.utils.file.FileUtils;

public class RegistryResourceMojo
extends AbstractMojo {
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private File artifact;
    private String extension;
    private String fileName;
    private boolean enableArchive;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File zipFile;
        if (!this.artifact.exists()) {
            throw new MojoExecutionException(this.artifact.getAbsolutePath() + " doesn't exist.");
        }
        File targetFolder = new File(this.project.getBuild().getDirectory());
        File sourceResourcesFolder = new File(this.artifact.getParentFile(), "resources");
        File allRegResources = new File(targetFolder, "all-reg-resources");
        File destinatiopnResourceFolder = new File(allRegResources, "resources");
        if (allRegResources.exists()) {
            RegistryResourceMojo.deleteDir(allRegResources);
        }
        allRegResources.mkdirs();
        try {
            FileUtils.copyDirectory((File)sourceResourcesFolder, (File)destinatiopnResourceFolder);
            FileUtils.copy((File)this.artifact, (File)new File(allRegResources, this.artifact.getName()));
            zipFile = new File(targetFolder, "resources.zip");
            ArchiveManipulator archiveManupulator = new ArchiveManipulator();
            archiveManupulator.archiveDir(zipFile, allRegResources);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error when copying " + this.artifact.getName() + " to " + destinatiopnResourceFolder.getName() + "\n" + e.getMessage());
        }
        if (zipFile == null || !zipFile.exists()) {
            throw new MojoExecutionException(destinatiopnResourceFolder + " is null or doesn't exist");
        }
        this.project.getArtifact().setFile(zipFile);
        if (this.enableArchive) {
            // empty if block
        }
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = RegistryResourceMojo.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public void copyAllRegResources(File resourceParent) throws IOException {
        File regResourceFile = new File(resourceParent, this.artifact.getName());
        File[] regFiles = this.artifact.getParentFile().listFiles();
        FileUtils.copy((File)this.artifact, (File)regResourceFile);
        for (File file : regFiles) {
            File destinationFile = new File(resourceParent, file.getName());
            if (!file.getName().equals("resources") || !file.isDirectory()) continue;
            FileUtils.copyDirectory((File)file, (File)destinationFile);
        }
    }
}

