/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.plugin.synapse.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.io.IOUtils;
import org.wso2.carbonstudio.eclipse.utils.file.FileUtils;
import org.wso2.maven.capp.model.CAppArtifactDependency;
import org.wso2.maven.plugin.synapse.utils.SynapseDependentArtifactExporter;
import org.wso2.maven.plugin.synapse.utils.SynapseDependentArtifactExporterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynapseArtifactBundleCreator {
    private SynapseDependentArtifactExporterFactory exporterFactory;
    private CAppArtifactDependency artifact;

    public SynapseArtifactBundleCreator(CAppArtifactDependency artifact) {
        this.setArtifact(artifact);
        this.exporterFactory = SynapseDependentArtifactExporterFactory.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CAppArtifactDependency> exportDependentArtifacts(File synapseXmlFile, CAppArtifactDependency synapseArtifactClone) throws Exception {
        FileInputStream fis = null;
        ArrayList<CAppArtifactDependency> list = new ArrayList<CAppArtifactDependency>();
        try {
            fis = new FileInputStream(synapseXmlFile);
            StAXOMBuilder builder = new StAXOMBuilder((InputStream)fis);
            OMElement documentElement = builder.getDocumentElement();
            documentElement.build();
            Iterator iter = documentElement.getChildElements();
            while (iter.hasNext()) {
                OMElement childElement = (OMElement)iter.next();
                SynapseDependentArtifactExporter exporter = this.exporterFactory.getExporter(childElement.getLocalName());
                if (null == exporter) continue;
                File workDir = FileUtils.createTempDirectory();
                try {
                    CAppArtifactDependency dependency = exporter.export(childElement, synapseArtifactClone, workDir);
                    if (dependency == null) continue;
                    list.add(dependency);
                }
                catch (Exception ex) {}
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fis);
        return list;
    }

    public void setArtifact(CAppArtifactDependency artifact) {
        this.artifact = artifact;
    }

    public CAppArtifactDependency getArtifact() {
        return this.artifact;
    }
}

