/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.registry;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.xml.stream.FactoryConfigurationError;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.wso2.maven.core.model.AbstractXMLDoc;
import org.wso2.maven.registry.RegistryArtifact;
import org.wso2.maven.registry.beans.RegistryCollection;
import org.wso2.maven.registry.beans.RegistryElement;
import org.wso2.maven.registry.beans.RegistryItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralProjectArtifact
extends AbstractXMLDoc
implements Observer {
    List<RegistryArtifact> registryArtifacts = new ArrayList<RegistryArtifact>();
    private File source;

    @Override
    public void update(Observable o, Object arg) {
    }

    protected void deserialize(OMElement documentElement) throws Exception {
        List artifactElements = this.getChildElements(documentElement, "artifact");
        for (OMElement omElement : artifactElements) {
            RegistryArtifact artifact = new RegistryArtifact();
            artifact.setName(this.getAttribute(omElement, "name"));
            artifact.setVersion(this.getAttribute(omElement, "version"));
            artifact.setType(this.getAttribute(omElement, "type"));
            artifact.setServerRole(this.getAttribute(omElement, "serverRole"));
            artifact.setGroupId(this.getAttribute(omElement, "groupId"));
            List itemElements = this.getChildElements(omElement, "item");
            for (OMElement omElement2 : itemElements) {
                RegistryItem item = new RegistryItem();
                item.setFile(((OMElement)this.getChildElements(omElement2, "file").get(0)).getText());
                item.setPath(((OMElement)this.getChildElements(omElement2, "path").get(0)).getText());
                List mediaTypeElements = this.getChildElements(omElement2, "mediaType");
                if (mediaTypeElements.size() > 0) {
                    item.setMediaType(((OMElement)mediaTypeElements.get(0)).getText());
                }
                artifact.addRegistryElement(item);
            }
            List itemElements1 = this.getChildElements(omElement, "collection");
            for (OMElement omElement2 : itemElements1) {
                RegistryCollection item = new RegistryCollection();
                item.setDirectory(((OMElement)this.getChildElements(omElement2, "directory").get(0)).getText());
                item.setPath(((OMElement)this.getChildElements(omElement2, "path").get(0)).getText());
                artifact.addRegistryElement(item);
            }
            this.registryArtifacts.add(artifact);
        }
    }

    protected String serialize() throws Exception {
        String result = null;
        OMDocument document = factory.createOMDocument();
        OMElement documentElement = this.getDocumentElement();
        document.addChild((OMNode)documentElement);
        try {
            result = this.getPretifiedString(documentElement);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return result;
    }

    protected String getDefaultName() {
        return null;
    }

    public void addESBArtifact(RegistryArtifact artifact) {
        this.registryArtifacts.add(artifact);
    }

    public boolean removeESBArtifact(RegistryArtifact artifact) {
        return this.registryArtifacts.remove(artifact);
    }

    public List<RegistryArtifact> getAllESBArtifacts() {
        return Collections.unmodifiableList(this.registryArtifacts);
    }

    public OMElement getDocumentElement() {
        OMElement documentElement = this.getElement("artifacts", "");
        for (RegistryArtifact esbArtifact : this.registryArtifacts) {
            OMElement artifactElement = this.getElement("artifact", "");
            if (!esbArtifact.isAnonymous()) {
                this.addAttribute(artifactElement, "name", esbArtifact.getName());
            }
            if (!esbArtifact.isAnonymous() && esbArtifact.getGroupId() != null) {
                this.addAttribute(artifactElement, "groupId", esbArtifact.getGroupId());
            }
            if (!esbArtifact.isAnonymous() && esbArtifact.getVersion() != null) {
                this.addAttribute(artifactElement, "version", esbArtifact.getVersion());
            }
            if (esbArtifact.getType() != null) {
                this.addAttribute(artifactElement, "type", esbArtifact.getType());
            }
            if (esbArtifact.getServerRole() != null) {
                this.addAttribute(artifactElement, "serverRole", esbArtifact.getServerRole());
            }
            for (RegistryElement item : esbArtifact.getAllRegistryItems()) {
                OMElement element3;
                OMElement element2;
                OMElement element;
                if (item instanceof RegistryItem) {
                    element = this.getElement("item", "");
                    element2 = this.getElement("file", ((RegistryItem)item).getFile());
                    element3 = this.getElement("path", item.getPath());
                    OMElement element4 = this.getElement("mediaType", ((RegistryItem)item).getMediaType());
                    element.addChild((OMNode)element2);
                    element.addChild((OMNode)element3);
                    element.addChild((OMNode)element4);
                    artifactElement.addChild((OMNode)element);
                    continue;
                }
                if (!(item instanceof RegistryCollection)) continue;
                element = this.getElement("collection", "");
                element2 = this.getElement("directory", ((RegistryCollection)item).getDirectory());
                element3 = this.getElement("path", item.getPath());
                element.addChild((OMNode)element2);
                element.addChild((OMNode)element3);
                artifactElement.addChild((OMNode)element);
            }
            documentElement.addChild((OMNode)artifactElement);
        }
        return documentElement;
    }

    public void setSource(File source) {
        this.source = source;
    }

    public File getSource() {
        return this.source;
    }

    public File toFile() throws Exception {
        File savedFile = new File(this.toFile(this.getSource()).toString());
        return savedFile;
    }

    public void fromFile(File file) throws FactoryConfigurationError, Exception {
        this.setSource(file);
        if (this.getSource().exists()) {
            this.deserialize(this.getSource());
        }
    }
}

