/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.wso2.maven.CAppHandler;
import org.wso2.maven.Constants;
import org.wso2.maven.datamapper.DataMapperBundler;
import org.wso2.maven.datamapper.DataMapperException;
import org.wso2.maven.libraries.ConnectorDependencyResolver;
import org.wso2.maven.model.ArchiveException;
import org.wso2.maven.model.ArtifactDependency;

public class CARMojo
extends AbstractMojo {
    MavenProject project;
    String archiveLocation;
    String archiveName;

    public void logError(String message) {
        this.getLog().error((CharSequence)message);
    }

    public void logInfo(String message) {
        this.getLog().info((CharSequence)message);
    }

    public String getArchiveName() {
        return this.archiveName == null ? this.project.getArtifactId() + "_" + this.project.getVersion() : this.archiveName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        String basedir = this.project.getBasedir().toString();
        this.archiveLocation = StringUtils.isEmpty((String)this.archiveLocation) ? basedir + File.separator + "target" : this.archiveLocation;
        String artifactFolderPath = basedir + File.separator + Constants.ARTIFACTS_FOLDER_PATH;
        String resourcesFolderPath = basedir + File.separator + Constants.RESOURCES_FOLDER_PATH;
        DataMapperBundler bundler = null;
        try {
            try {
                bundler = new DataMapperBundler(this, resourcesFolderPath);
                bundler.bundleDataMapper();
            }
            catch (DataMapperException e) {
                this.getLog().error((CharSequence)("Error during data mapper bundling: " + e.getMessage()), (Throwable)e);
                throw new MojoExecutionException("Data Mapper bundling failed.", (Exception)e);
            }
            this.processCARCreation(basedir, artifactFolderPath, resourcesFolderPath);
        }
        finally {
            if (bundler != null) {
                try {
                    bundler.deleteGeneratedDatamapperArtifacts();
                }
                catch (DataMapperException e) {
                    this.getLog().error((CharSequence)("Error during data mapper cleanup: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private void processCARCreation(String basedir, String artifactFolderPath, String resourcesFolderPath) throws MojoExecutionException {
        this.appendLogs();
        File artifactFolder = new File(artifactFolderPath);
        File resourcesFolder = new File(resourcesFolderPath);
        boolean createdArchiveDirectory = false;
        String tempTargetDir = basedir + File.separator + "tmp";
        File targetFolder = new File(tempTargetDir);
        if (!targetFolder.exists()) {
            createdArchiveDirectory = targetFolder.mkdir();
        }
        CAppHandler cAppHandler = new CAppHandler(this.getArchiveName(), this);
        ArrayList<ArtifactDependency> dependencies = new ArrayList<ArtifactDependency>();
        ArrayList<ArtifactDependency> metaDependencies = new ArrayList<ArtifactDependency>();
        if (createdArchiveDirectory || targetFolder.exists()) {
            String projectVersion = this.project.getVersion().replace("-SNAPSHOT", "");
            cAppHandler.processArtifacts(artifactFolder, tempTargetDir, dependencies, metaDependencies, projectVersion);
            cAppHandler.processAPIDefinitions(resourcesFolder, tempTargetDir, metaDependencies, projectVersion);
            cAppHandler.processResourcesFolder(resourcesFolder, tempTargetDir, dependencies, metaDependencies, projectVersion);
            cAppHandler.processClassMediators(dependencies, this.project);
            this.resolveConnectorDependencies();
            cAppHandler.processConnectorLibDependencies(dependencies, this.project);
            cAppHandler.createDependencyArtifactsXmlFile(tempTargetDir, dependencies, metaDependencies, this.project);
            File fileToZip = new File(tempTargetDir);
            String fileExtension = ".car";
            try {
                File carFile = this.getArchiveFile(fileExtension);
                this.zipFolder(fileToZip.getPath(), carFile.getPath(), fileExtension);
                this.project.getArtifact().setFile(carFile);
            }
            catch (ArchiveException e) {
                this.logError("Error occurred while creating the .car file");
                this.logError(e.getMessage());
            }
            this.recursiveDelete(fileToZip, fileExtension);
        } else {
            this.getLog().error((CharSequence)"Could not create the archive directory.");
        }
    }

    private void appendLogs() {
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        this.getLog().info((CharSequence)"Building Composite Project");
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
    }

    private File getArchiveFile(String fileExtension) {
        File archiveLocation = new File(this.archiveLocation);
        if (!archiveLocation.exists()) {
            archiveLocation.mkdir();
        }
        return new File(archiveLocation, this.getArchiveName() + fileExtension);
    }

    private void zipFolder(String srcFolder, String destZipFile, String fileExtension) throws ArchiveException {
        try (FileOutputStream fileWriter = new FileOutputStream(destZipFile);
             ZipOutputStream zip = new ZipOutputStream(fileWriter);){
            this.addFolderContentsToZip(srcFolder, zip, fileExtension);
            zip.flush();
        }
        catch (IOException ex) {
            throw new ArchiveException("Error occurred while creating CAR file.", ex);
        }
    }

    private void addFolderContentsToZip(String srcFolder, ZipOutputStream zip, String fileExtension) throws ArchiveException {
        File folder = new File(srcFolder);
        String[] fileList = folder.list();
        if (fileList == null) {
            return;
        }
        try {
            int i = 0;
            while (fileList.length != i) {
                if (new File(folder, fileList[i]).isDirectory()) {
                    zip.putNextEntry(new ZipEntry(fileList[i] + "/"));
                    zip.closeEntry();
                }
                if (this.getArchiveName().concat(fileExtension).equals(fileList[i])) {
                    ++i;
                    continue;
                }
                this.addToZip("", srcFolder + "/" + fileList[i], zip);
                ++i;
            }
        }
        catch (IOException ex) {
            throw new ArchiveException("Error occurred while creating CAR file.", ex);
        }
    }

    private void addToZip(String path, String srcFile, ZipOutputStream zip) throws ArchiveException {
        File folder = new File(srcFile);
        if (folder.isDirectory()) {
            this.addFolderToZip(path, srcFile, zip);
        } else {
            byte[] buf = new byte[1024];
            try (FileInputStream in = new FileInputStream(srcFile);){
                int len;
                if (path.trim().equals("")) {
                    zip.putNextEntry(new ZipEntry(folder.getName()));
                } else {
                    zip.putNextEntry(new ZipEntry(path + "/" + folder.getName()));
                }
                while ((len = in.read(buf)) > 0) {
                    zip.write(buf, 0, len);
                }
            }
            catch (IOException ex) {
                throw new ArchiveException("Error occurred while creating CAR file.", ex);
            }
        }
    }

    private void addFolderToZip(String path, String srcFolder, ZipOutputStream zip) throws ArchiveException {
        File folder = new File(srcFolder);
        String[] fileList = folder.list();
        if (fileList == null) {
            return;
        }
        try {
            for (int i = 0; fileList.length != i; ++i) {
                String newPath = folder.getName();
                if (!path.equalsIgnoreCase("")) {
                    newPath = path + "/" + newPath;
                }
                if (new File(folder, fileList[i]).isDirectory()) {
                    zip.putNextEntry(new ZipEntry(newPath + "/" + fileList[i] + "/"));
                }
                this.addToZip(newPath, srcFolder + "/" + fileList[i], zip);
            }
        }
        catch (IOException ex) {
            throw new ArchiveException("Error occurred while creating CAR file.", ex);
        }
    }

    private void recursiveDelete(File file, String fileExtension) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            for (File f : files) {
                this.recursiveDelete(f, fileExtension);
            }
        } else if (file.getName().equals(this.getArchiveName().concat(fileExtension))) {
            return;
        }
        file.delete();
    }

    private void resolveConnectorDependencies() throws MojoExecutionException {
        try {
            ConnectorDependencyResolver.resolveDependencies(this);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error occurred while resolving connector dependencies.", (Throwable)e);
            throw new MojoExecutionException("Connector dependency resolution failed.", e);
        }
    }
}

