/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.AmqMethodRegistry;

public class AmqpMethodDecoder {
    private static final int SIZE_WITHOUT_PAYLOAD = 8;
    private static final AmqMethodRegistry methodRegistry = new AmqMethodRegistry();

    public static void parse(ByteBuf buffer, List<Object> out) throws Exception {
        buffer.markReaderIndex();
        if (buffer.readableBytes() > 8) {
            byte type = buffer.readByte();
            short channel = buffer.readShort();
            long payloadSize = buffer.readInt();
            long estimatedRemainingSize = payloadSize + 1L;
            if ((long)buffer.readableBytes() < estimatedRemainingSize) {
                buffer.resetReaderIndex();
                return;
            }
            switch (type) {
                case 1: {
                    short amqpClass = buffer.readShort();
                    short amqpMethod = buffer.readShort();
                    AmqMethodBodyFactory factory = methodRegistry.getFactory(amqpClass, amqpMethod);
                    out.add(factory.newInstance(buffer, channel, payloadSize));
                    buffer.readByte();
                    return;
                }
                case 2: {
                    throw new Exception("Method Not implemented");
                }
                case 3: {
                    throw new Exception("Method Not implemented");
                }
                case 4: {
                    throw new Exception("Method Not implemented");
                }
            }
        }
    }
}

