/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.data;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.wso2.broker.amqp.codec.data.EncodableData;

public class ShortString
implements EncodableData {
    private static final int MAX_LENGTH = 255;
    private final long length;
    private final byte[] content;

    public ShortString(long length, char[] content) {
        this.length = length;
        this.content = new String(content).getBytes(StandardCharsets.UTF_8);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ShortString(long length, byte[] content) {
        this.length = length;
        this.content = content;
    }

    @Override
    public long getSize() {
        return this.length + 1L;
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeByte((int)this.length);
        buf.writeBytes(this.content);
    }

    public static ShortString parse(ByteBuf buf) {
        short size = buf.readUnsignedByte();
        byte[] data = new byte[size];
        buf.readBytes(data);
        return new ShortString((long)size, data);
    }

    public String toString() {
        return new String(this.content, StandardCharsets.UTF_8);
    }
}

