/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.wso2.broker.amqp.codec.AmqpConnectionHandler;
import org.wso2.broker.amqp.codec.data.FieldTable;
import org.wso2.broker.amqp.codec.data.ShortString;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.ExchangeDeclareOk;
import org.wso2.broker.amqp.codec.frames.MethodFrame;

public class ExchangeDeclare
extends MethodFrame {
    private final ShortString exchange;
    private final ShortString type;
    private final boolean passive;
    private final boolean durable;
    private final boolean noWait;
    private final FieldTable arguments;

    public ExchangeDeclare(int channel, ShortString exchange, ShortString type, boolean passive, boolean durable, boolean noWait, FieldTable arguments) {
        super(channel, (short)40, (short)10);
        this.exchange = exchange;
        this.type = type;
        this.passive = passive;
        this.durable = durable;
        this.noWait = noWait;
        this.arguments = arguments;
    }

    @Override
    protected long getMethodBodySize() {
        return 2L + this.exchange.getSize() + this.type.getSize() + 1L + this.arguments.getSize();
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeShort(0);
        this.exchange.write(buf);
        this.type.write(buf);
        byte flags = 0;
        if (this.passive) {
            flags = (byte)(flags | 1);
        }
        if (this.durable) {
            flags = (byte)(flags | 2);
        }
        if (this.noWait) {
            flags = (byte)(flags | 0x10);
        }
        buf.writeByte((int)flags);
        this.arguments.write(buf);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        ctx.writeAndFlush((Object)new ExchangeDeclareOk(this.getChannel()));
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            buf.skipBytes(2);
            ShortString exchange = ShortString.parse(buf);
            ShortString type = ShortString.parse(buf);
            byte flags = buf.readByte();
            boolean passive = (flags & 1) == 1;
            boolean durable = (flags & 2) == 2;
            boolean noWait = (flags & 0x10) == 16;
            FieldTable arguments = FieldTable.parse(buf);
            return new ExchangeDeclare(channel, exchange, type, passive, durable, noWait, arguments);
        };
    }
}

