/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.codec.AmqpConnectionHandler;
import org.wso2.broker.amqp.codec.data.ShortString;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.ConnectionCloseOk;
import org.wso2.broker.amqp.codec.frames.MethodFrame;

public class ConnectionClose
extends MethodFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionClose.class);
    private final int replyCode;
    private final ShortString replyText;
    private final int classId;
    private final int methodId;

    public ConnectionClose(int replyCode, ShortString replyText, int classId, int methodId) {
        super(0, (short)10, (short)50);
        this.replyCode = replyCode;
        this.replyText = replyText;
        this.classId = classId;
        this.methodId = methodId;
    }

    @Override
    protected long getMethodBodySize() {
        return 2L + this.replyText.getSize() + 2L + 2L;
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeShort(this.replyCode);
        this.replyText.write(buf);
        buf.writeShort(this.classId);
        buf.writeShort(this.methodId);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        connectionHandler.close();
        ctx.writeAndFlush((Object)new ConnectionCloseOk(this.getChannel())).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            int replyCode = buf.readUnsignedShort();
            ShortString replyText = ShortString.parse(buf);
            int classId = buf.readUnsignedShort();
            int methodId = buf.readUnsignedShort();
            return new ConnectionClose(replyCode, replyText, classId, methodId);
        };
    }
}

