/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import org.wso2.broker.amqp.codec.AmqFrameDecodingException;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.BasicAck;
import org.wso2.broker.amqp.codec.frames.BasicCancel;
import org.wso2.broker.amqp.codec.frames.BasicCancelOk;
import org.wso2.broker.amqp.codec.frames.BasicConsume;
import org.wso2.broker.amqp.codec.frames.BasicConsumeOk;
import org.wso2.broker.amqp.codec.frames.BasicDeliver;
import org.wso2.broker.amqp.codec.frames.BasicPublish;
import org.wso2.broker.amqp.codec.frames.BasicQos;
import org.wso2.broker.amqp.codec.frames.BasicQosOk;
import org.wso2.broker.amqp.codec.frames.ChannelClose;
import org.wso2.broker.amqp.codec.frames.ChannelCloseOk;
import org.wso2.broker.amqp.codec.frames.ChannelFlow;
import org.wso2.broker.amqp.codec.frames.ChannelFlowOk;
import org.wso2.broker.amqp.codec.frames.ChannelOpen;
import org.wso2.broker.amqp.codec.frames.ChannelOpenOk;
import org.wso2.broker.amqp.codec.frames.ConnectionClose;
import org.wso2.broker.amqp.codec.frames.ConnectionCloseOk;
import org.wso2.broker.amqp.codec.frames.ConnectionOpen;
import org.wso2.broker.amqp.codec.frames.ConnectionOpenOk;
import org.wso2.broker.amqp.codec.frames.ConnectionStartOk;
import org.wso2.broker.amqp.codec.frames.ConnectionTuneOk;
import org.wso2.broker.amqp.codec.frames.ExchangeDeclare;
import org.wso2.broker.amqp.codec.frames.ExchangeDeclareOk;
import org.wso2.broker.amqp.codec.frames.QueueBind;
import org.wso2.broker.amqp.codec.frames.QueueBindOk;
import org.wso2.broker.amqp.codec.frames.QueueDeclare;
import org.wso2.broker.amqp.codec.frames.QueueDeclareOk;

public class AmqMethodRegistry {
    public AmqMethodBodyFactory[][] factories = new AmqMethodBodyFactory[101][];

    public AmqMethodRegistry() {
        this.factories[10] = new AmqMethodBodyFactory[52];
        this.factories[10][11] = ConnectionStartOk.getFactory();
        this.factories[10][31] = ConnectionTuneOk.getFactory();
        this.factories[10][40] = ConnectionOpen.getFactory();
        this.factories[10][41] = ConnectionOpenOk.getFactory();
        this.factories[10][50] = ConnectionClose.getFactory();
        this.factories[10][51] = ConnectionCloseOk.getFactory();
        this.factories[20] = new AmqMethodBodyFactory[42];
        this.factories[20][10] = ChannelOpen.getFactory();
        this.factories[20][11] = ChannelOpenOk.getFactory();
        this.factories[20][20] = ChannelFlow.getFactory();
        this.factories[20][21] = ChannelFlowOk.getFactory();
        this.factories[20][40] = ChannelClose.getFactory();
        this.factories[20][41] = ChannelCloseOk.getFactory();
        this.factories[40] = new AmqMethodBodyFactory[24];
        this.factories[40][10] = ExchangeDeclare.getFactory();
        this.factories[40][11] = ExchangeDeclareOk.getFactory();
        this.factories[50] = new AmqMethodBodyFactory[52];
        this.factories[50][10] = QueueDeclare.getFactory();
        this.factories[50][11] = QueueDeclareOk.getFactory();
        this.factories[50][20] = QueueBind.getFactory();
        this.factories[50][21] = QueueBindOk.getFactory();
        this.factories[60] = new AmqMethodBodyFactory[112];
        this.factories[60][10] = BasicQos.getFactory();
        this.factories[60][11] = BasicQosOk.getFactory();
        this.factories[60][20] = BasicConsume.getFactory();
        this.factories[60][21] = BasicConsumeOk.getFactory();
        this.factories[60][30] = BasicCancel.getFactory();
        this.factories[60][31] = BasicCancelOk.getFactory();
        this.factories[60][40] = BasicPublish.getFactory();
        this.factories[60][60] = BasicDeliver.getFactory();
        this.factories[60][80] = BasicAck.getFactory();
    }

    public AmqMethodBodyFactory getFactory(short classId, short methodId) throws AmqFrameDecodingException {
        try {
            return this.factories[classId][methodId];
        }
        catch (NullPointerException e) {
            throw new AmqFrameDecodingException(503, "Class " + classId + " unknown in AMQP version 0-91" + " (while trying to decode class " + classId + " method " + methodId + ".");
        }
        catch (IndexOutOfBoundsException e) {
            if (classId >= this.factories.length) {
                throw new AmqFrameDecodingException(503, "Class " + classId + " unknown in AMQP version 0-91" + " (while trying to decode class " + classId + " method " + methodId + ".");
            }
            throw new AmqFrameDecodingException(503, "Method " + methodId + " unknown in AMQP version 0-91" + " (while trying to decode class " + classId + " method " + methodId + ".");
        }
    }
}

