/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.codec.AmqpChannel;
import org.wso2.broker.amqp.codec.AmqpConnectionHandler;
import org.wso2.broker.amqp.codec.data.FieldTable;
import org.wso2.broker.amqp.codec.data.ShortString;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.ChannelClose;
import org.wso2.broker.amqp.codec.frames.MethodFrame;
import org.wso2.broker.amqp.codec.frames.QueueDeclareOk;
import org.wso2.broker.core.BrokerException;

public class QueueDeclare
extends MethodFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueueDeclare.class);
    private static final short CLASS_ID = 50;
    private static final short METHOD_ID = 10;
    private final ShortString queue;
    private final boolean passive;
    private final boolean durable;
    private final boolean exclusive;
    private final boolean autoDelete;
    private final boolean noWait;
    private final FieldTable arguments;

    public QueueDeclare(int channel, ShortString queue, boolean passive, boolean durable, boolean exclusive, boolean autoDelete, boolean noWait, FieldTable arguments) {
        super(channel, (short)50, (short)10);
        this.queue = queue;
        this.passive = passive;
        this.durable = durable;
        this.exclusive = exclusive;
        this.autoDelete = autoDelete;
        this.noWait = noWait;
        this.arguments = arguments;
    }

    @Override
    protected long getMethodBodySize() {
        return 2L + this.queue.getSize() + 1L + this.arguments.getSize();
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeShort(0);
        this.queue.write(buf);
        byte flags = 0;
        if (this.passive) {
            flags = (byte)(flags | 1);
        }
        if (this.durable) {
            flags = (byte)(flags | 2);
        }
        if (this.exclusive) {
            flags = (byte)(flags | 4);
        }
        if (this.autoDelete) {
            flags = (byte)(flags | 8);
        }
        if (this.noWait) {
            flags = (byte)(flags | 0x10);
        }
        buf.writeByte((int)flags);
        this.arguments.write(buf);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        try {
            AmqpChannel channel = connectionHandler.getChannel(this.getChannel());
            channel.declareQueue(this.queue, this.passive, this.durable, this.autoDelete);
            ctx.writeAndFlush((Object)new QueueDeclareOk(this.getChannel(), this.queue, 0L, 0L));
        }
        catch (BrokerException e) {
            LOGGER.warn("Error declaring queue.", (Throwable)e);
            ctx.writeAndFlush((Object)new ChannelClose(this.getChannel(), 530, ShortString.parseString(e.getMessage()), 50, 10));
        }
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            buf.skipBytes(2);
            ShortString queue = ShortString.parse(buf);
            byte flags = buf.readByte();
            boolean passive = (flags & 1) == 1;
            boolean durable = (flags & 2) == 2;
            boolean exclusive = (flags & 4) == 4;
            boolean autoDelete = (flags & 8) == 8;
            boolean noWait = (flags & 0x10) == 16;
            FieldTable arguments = FieldTable.parse(buf);
            return new QueueDeclare(channel, queue, passive, durable, exclusive, autoDelete, noWait, arguments);
        };
    }
}

