/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec;

import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.wso2.broker.amqp.AmqpConsumer;
import org.wso2.broker.amqp.AmqpException;
import org.wso2.broker.amqp.codec.InMemoryMessageAggregator;
import org.wso2.broker.amqp.codec.data.ShortString;
import org.wso2.broker.core.Broker;
import org.wso2.broker.core.BrokerException;
import org.wso2.broker.core.Consumer;

public class AmqpChannel {
    private final Broker broker;
    private final int channelId;
    private final Map<ShortString, AmqpConsumer> consumerMap;
    private InMemoryMessageAggregator messageAggregator;

    AmqpChannel(Broker broker, int channelId) {
        this.broker = broker;
        this.channelId = channelId;
        this.consumerMap = new HashMap<ShortString, AmqpConsumer>();
    }

    public void declareExchange(String exchangeName, String exchangeType, boolean passive, boolean durable) throws BrokerException {
        this.broker.createExchange(exchangeName, exchangeType, passive, durable);
    }

    public void declareQueue(ShortString queue, boolean passive, boolean durable, boolean autoDelete) throws BrokerException {
        this.broker.createQueue(queue.toString(), passive, durable, autoDelete);
    }

    public void bind(ShortString queue, ShortString exchange, ShortString routingKey) throws BrokerException {
        this.broker.bind(queue.toString(), exchange.toString(), routingKey.toString());
    }

    public ShortString consume(ShortString queueName, ShortString consumerTag, boolean exclusive, ChannelHandlerContext ctx) throws BrokerException {
        String tag = consumerTag.toString();
        if (tag.isEmpty()) {
            tag = UUID.randomUUID().toString();
        }
        AmqpConsumer amqpConsumer = new AmqpConsumer(ctx, this.channelId, queueName.toString(), tag, exclusive);
        this.consumerMap.put(consumerTag, amqpConsumer);
        this.broker.addConsumer((Consumer)amqpConsumer);
        return new ShortString((long)tag.length(), tag.getBytes(StandardCharsets.UTF_8));
    }

    public void close() {
        for (Consumer consumer : this.consumerMap.values()) {
            this.broker.removeConsumer(consumer);
        }
    }

    public void cancelConsumer(ShortString consumerTag) throws AmqpException {
        AmqpConsumer amqpConsumer = this.consumerMap.get(consumerTag);
        if (amqpConsumer == null) {
            throw new AmqpException("Invalid Consumer tag [ " + consumerTag + " ] for the channel: " + this.channelId);
        }
        this.broker.removeConsumer((Consumer)amqpConsumer);
    }

    public InMemoryMessageAggregator createMessageAggregator() {
        this.messageAggregator = new InMemoryMessageAggregator(this.broker);
        return this.messageAggregator;
    }

    public InMemoryMessageAggregator getMessageAggregator() {
        return this.messageAggregator;
    }
}

