/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.codec.AmqpChannel;
import org.wso2.broker.amqp.codec.ConnectionException;
import org.wso2.broker.amqp.codec.frames.AmqpBadMessage;
import org.wso2.broker.amqp.codec.frames.ConnectionStart;
import org.wso2.broker.amqp.codec.frames.GeneralFrame;
import org.wso2.broker.amqp.codec.frames.ProtocolInitFrame;
import org.wso2.broker.core.Broker;

public class AmqpConnectionHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpConnectionHandler.class);
    private final Map<Integer, AmqpChannel> channels = new HashMap<Integer, AmqpChannel>();
    private final Broker broker;

    public AmqpConnectionHandler(Broker broker) {
        this.broker = broker;
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        ctx.channel().closeFuture().addListener(future -> this.close());
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ProtocolInitFrame) {
            this.handleProtocolInit(ctx, (ProtocolInitFrame)msg);
        } else if (msg instanceof GeneralFrame) {
            ((GeneralFrame)msg).handle(ctx, this);
        } else if (msg instanceof AmqpBadMessage) {
            LOGGER.warn("Bad message received", ((AmqpBadMessage)msg).getCause());
            ctx.close();
            this.close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.warn("Exception while handling request", cause);
        ctx.close();
        this.close();
    }

    private void handleProtocolInit(ChannelHandlerContext ctx, ProtocolInitFrame msg) {
        if (ProtocolInitFrame.V_091.equals(msg)) {
            ctx.writeAndFlush((Object)ConnectionStart.DEFAULT_FRAME);
        } else {
            ctx.writeAndFlush((Object)ProtocolInitFrame.V_091);
        }
    }

    public void createChannel(int channelId) throws ConnectionException {
        AmqpChannel channel = this.channels.get(channelId);
        if (channel != null) {
            throw new ConnectionException(504, "Channel ID " + channelId + " Already exists");
        }
        this.channels.put(channelId, new AmqpChannel(this.broker, channelId));
    }

    public AmqpChannel getChannel(int channelId) {
        return this.channels.get(channelId);
    }

    public void closeChannel(int channel) {
        this.channels.remove(channel);
    }

    public void close() {
        for (AmqpChannel channel : this.channels.values()) {
            channel.close();
        }
    }
}

