/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec;

import io.netty.buffer.ByteBuf;
import org.wso2.broker.amqp.AmqpException;
import org.wso2.broker.amqp.codec.data.ShortString;
import org.wso2.broker.core.Broker;
import org.wso2.broker.core.BrokerException;
import org.wso2.broker.core.ContentChunk;
import org.wso2.broker.core.Message;
import org.wso2.broker.core.Metadata;

public class InMemoryMessageAggregator {
    private Message message;
    private final Broker broker;
    private String routingKey;
    private String exchangeName;
    private long receivedPayloadSize;

    public InMemoryMessageAggregator(Broker broker) {
        this.broker = broker;
    }

    public void basicPublishReceived(ShortString routingKey, ShortString exchangeName) {
        this.routingKey = routingKey.toString();
        this.exchangeName = exchangeName.toString();
    }

    public void headerFrameReceived(ByteBuf rawMetadata, long payloadSize) {
        long messageId = this.broker.getNextMessageId();
        Metadata metadata = new Metadata(messageId, this.routingKey, this.exchangeName, payloadSize);
        metadata.setRawMetadata(rawMetadata);
        this.message = new Message(metadata);
    }

    private void clear() {
        this.message.release();
        this.message = null;
        this.routingKey = null;
        this.exchangeName = null;
        this.receivedPayloadSize = 0L;
    }

    public void publish(Message message) throws BrokerException {
        this.broker.publish(message);
    }

    public boolean contentBodyReceived(long length, ByteBuf payload) throws AmqpException {
        ContentChunk contentChunk = new ContentChunk(this.receivedPayloadSize, payload);
        this.message.addChunk(contentChunk);
        this.receivedPayloadSize += length;
        long contentLength = this.message.getMetadata().getContentLength();
        if (contentLength == this.receivedPayloadSize) {
            return true;
        }
        if (contentLength < this.receivedPayloadSize) {
            this.clear();
            throw new AmqpException("Content length mismatch. Received content more than the expected size");
        }
        return false;
    }

    public Message getMessage() {
        return this.message;
    }
}

