/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.codec.frames.BasicDeliver;
import org.wso2.broker.amqp.codec.frames.ContentFrame;
import org.wso2.broker.amqp.codec.frames.HeaderFrame;
import org.wso2.broker.common.data.types.ShortString;
import org.wso2.broker.core.Consumer;
import org.wso2.broker.core.ContentChunk;
import org.wso2.broker.core.Message;
import org.wso2.broker.core.Metadata;

public class AmqpConsumer
implements Consumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpConsumer.class);
    private final String queueName;
    private final String consumerTag;
    private final boolean isExclusive;
    private final ChannelHandlerContext context;
    private final int channelId;
    private ChannelFutureListener errorLogger;

    public AmqpConsumer(ChannelHandlerContext ctx, int channelId, String queueName, String consumerTag, boolean isExclusive) {
        this.queueName = queueName;
        this.consumerTag = consumerTag;
        this.isExclusive = isExclusive;
        this.context = ctx;
        this.channelId = channelId;
        this.errorLogger = new ErrorLogger(queueName);
    }

    public void send(Message message, long deliveryTag) {
        Metadata metadata = message.getMetadata();
        BasicDeliver basicDeliver = new BasicDeliver(this.channelId, ShortString.parseString((String)this.consumerTag), deliveryTag, false, ShortString.parseString((String)metadata.getExchangeName()), ShortString.parseString((String)metadata.getRoutingKey()));
        HeaderFrame headerFrame = new HeaderFrame(this.channelId, 60, metadata.getContentLength());
        headerFrame.setRawMetadata(metadata.getRawMetadata());
        this.context.write((Object)basicDeliver).addListener((GenericFutureListener)this.errorLogger);
        this.context.write((Object)headerFrame).addListener((GenericFutureListener)this.errorLogger);
        for (ContentChunk chunk : message.getContentChunks()) {
            ContentFrame contentFrame = new ContentFrame(this.channelId, chunk.getBytes().capacity(), chunk.getBytes());
            this.context.write((Object)contentFrame).addListener((GenericFutureListener)this.errorLogger);
        }
        this.context.flush();
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void close() {
    }

    public String getConsumerTag() {
        return this.consumerTag;
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    private static class ErrorLogger
    implements ChannelFutureListener {
        private final String queueName;

        private ErrorLogger(String queueName) {
            this.queueName = queueName;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (!future.isSuccess()) {
                LOGGER.warn("Error while sending message for " + this.queueName, future.cause());
            }
        }
    }
}

