/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp;

import io.netty.channel.ChannelHandlerContext;
import org.wso2.broker.amqp.codec.frames.BasicDeliver;
import org.wso2.broker.amqp.codec.frames.ContentFrame;
import org.wso2.broker.amqp.codec.frames.HeaderFrame;
import org.wso2.broker.common.data.types.ShortString;
import org.wso2.broker.core.ContentChunk;
import org.wso2.broker.core.Message;
import org.wso2.broker.core.Metadata;

public class AmqpDeliverMessage {
    private final String consumerTag;
    private final int channelId;
    private final long deliveryTag;
    private final Message message;

    public AmqpDeliverMessage(Message message, String consumerTag, int channelId, long deliveryTag) {
        this.message = message;
        this.consumerTag = consumerTag;
        this.channelId = channelId;
        this.deliveryTag = deliveryTag;
    }

    public void write(ChannelHandlerContext ctx) {
        Metadata metadata = this.message.getMetadata();
        BasicDeliver basicDeliverFrame = new BasicDeliver(this.channelId, ShortString.parseString((String)this.consumerTag), this.deliveryTag, false, ShortString.parseString((String)metadata.getExchangeName()), ShortString.parseString((String)metadata.getRoutingKey()));
        HeaderFrame headerFrame = new HeaderFrame(this.channelId, 60, metadata.getContentLength());
        headerFrame.setRawMetadata(metadata.getRawMetadata());
        ctx.write((Object)basicDeliverFrame);
        ctx.write((Object)headerFrame);
        for (ContentChunk chunk : this.message.getContentChunks()) {
            ContentFrame contentFrame = new ContentFrame(this.channelId, chunk.getBytes().capacity(), chunk.getBytes());
            ctx.write((Object)contentFrame);
        }
    }
}

