/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.wso2.broker.amqp.codec.AmqpConnectionHandler;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.MethodFrame;
import org.wso2.broker.common.data.types.ShortString;

public class BasicDeliver
extends MethodFrame {
    private final ShortString consumerTag;
    private final long deliveryTag;
    private final boolean redelivered;
    private final ShortString exchange;
    private final ShortString routingKey;

    public BasicDeliver(int channel, ShortString consumerTag, long deliveryTag, boolean redelivered, ShortString exchange, ShortString routingKey) {
        super(channel, (short)60, (short)60);
        this.consumerTag = consumerTag;
        this.deliveryTag = deliveryTag;
        this.redelivered = redelivered;
        this.exchange = exchange;
        this.routingKey = routingKey;
    }

    @Override
    protected long getMethodBodySize() {
        return this.consumerTag.getSize() + 8L + 1L + this.exchange.getSize() + this.routingKey.getSize();
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        this.consumerTag.write(buf);
        buf.writeLong(this.deliveryTag);
        buf.writeBoolean(this.redelivered);
        this.exchange.write(buf);
        this.routingKey.write(buf);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            ShortString consumerTag = ShortString.parse((ByteBuf)buf);
            long deliveryTag = buf.readLong();
            boolean redelivered = buf.readBoolean();
            ShortString exchange = ShortString.parse((ByteBuf)buf);
            ShortString routingKey = ShortString.parse((ByteBuf)buf);
            return new BasicDeliver(channel, consumerTag, deliveryTag, redelivered, exchange, routingKey);
        };
    }
}

