/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.codec.AmqpChannel;
import org.wso2.broker.amqp.codec.AmqpConnectionHandler;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.ChannelClose;
import org.wso2.broker.amqp.codec.frames.MethodFrame;
import org.wso2.broker.amqp.codec.frames.QueueBindOk;
import org.wso2.broker.common.data.types.FieldTable;
import org.wso2.broker.common.data.types.ShortString;
import org.wso2.broker.core.BrokerException;

public class QueueBind
extends MethodFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueueBind.class);
    private static final short CLASS_ID = 50;
    private static final short METHOD_ID = 20;
    private final ShortString queue;
    private final ShortString exchange;
    private final ShortString routingKey;
    private final boolean noWait;
    private final FieldTable arguments;

    public QueueBind(int channel, ShortString queue, ShortString exchange, ShortString routingKey, boolean noWait, FieldTable arguments) {
        super(channel, (short)50, (short)20);
        this.queue = queue;
        this.exchange = exchange;
        this.routingKey = routingKey;
        this.noWait = noWait;
        this.arguments = arguments;
    }

    @Override
    protected long getMethodBodySize() {
        return 2L + this.queue.getSize() + this.exchange.getSize() + this.routingKey.getSize() + 1L + this.arguments.getSize();
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeShort(0);
        this.queue.write(buf);
        this.exchange.write(buf);
        this.routingKey.write(buf);
        buf.writeBoolean(this.noWait);
        this.arguments.write(buf);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        AmqpChannel channel = connectionHandler.getChannel(this.getChannel());
        ctx.fireChannelRead(() -> {
            try {
                channel.bind(this.queue, this.exchange, this.routingKey, this.arguments);
                ctx.writeAndFlush((Object)new QueueBindOk(this.getChannel()));
            }
            catch (BrokerException e) {
                ctx.writeAndFlush((Object)new ChannelClose(this.getChannel(), 530, ShortString.parseString((String)e.getMessage()), 50, 20));
            }
        });
    }

    public ShortString getQueue() {
        return this.queue;
    }

    public ShortString getExchange() {
        return this.exchange;
    }

    public ShortString getRoutingKey() {
        return this.routingKey;
    }

    public boolean isNoWait() {
        return this.noWait;
    }

    public FieldTable getArguments() {
        return this.arguments;
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            buf.skipBytes(2);
            ShortString queue = ShortString.parse((ByteBuf)buf);
            ShortString exchange = ShortString.parse((ByteBuf)buf);
            ShortString routingKey = ShortString.parse((ByteBuf)buf);
            boolean noWait = buf.readBoolean();
            FieldTable arguments = FieldTable.parse((ByteBuf)buf);
            return new QueueBind(channel, queue, exchange, routingKey, noWait, arguments);
        };
    }
}

