/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec;

import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.wso2.broker.amqp.AckData;
import org.wso2.broker.amqp.AmqpConsumer;
import org.wso2.broker.amqp.AmqpException;
import org.wso2.broker.amqp.codec.InMemoryMessageAggregator;
import org.wso2.broker.common.data.types.FieldTable;
import org.wso2.broker.common.data.types.ShortString;
import org.wso2.broker.core.Broker;
import org.wso2.broker.core.BrokerException;
import org.wso2.broker.core.Consumer;

public class AmqpChannel {
    private final Broker broker;
    private final int channelId;
    private final Map<ShortString, AmqpConsumer> consumerMap;
    private final InMemoryMessageAggregator messageAggregator;
    private AtomicInteger consumerTagGenerator = new AtomicInteger(0);
    private AtomicLong deliveryTagGenerator = new AtomicLong(0L);
    private Map<Long, AckData> unackedMessageMap = new HashMap<Long, AckData>();

    AmqpChannel(Broker broker, int channelId) {
        this.broker = broker;
        this.channelId = channelId;
        this.consumerMap = new HashMap<ShortString, AmqpConsumer>();
        this.messageAggregator = new InMemoryMessageAggregator(broker);
    }

    public void declareExchange(String exchangeName, String exchangeType, boolean passive, boolean durable) throws BrokerException {
        this.broker.createExchange(exchangeName, exchangeType, passive, durable);
    }

    public void declareQueue(ShortString queue, boolean passive, boolean durable, boolean autoDelete) throws BrokerException {
        this.broker.createQueue(queue.toString(), passive, durable, autoDelete);
    }

    public void bind(ShortString queue, ShortString exchange, ShortString routingKey, FieldTable arguments) throws BrokerException {
        this.broker.bind(queue.toString(), exchange.toString(), routingKey.toString(), arguments);
    }

    public ShortString consume(ShortString queueName, ShortString consumerTag, boolean exclusive, ChannelHandlerContext ctx) throws BrokerException {
        String tag = consumerTag.toString();
        if (tag.isEmpty()) {
            tag = "sgen" + this.getNextConsumerTag();
        }
        AmqpConsumer amqpConsumer = new AmqpConsumer(ctx, this, queueName.toString(), tag, exclusive);
        this.consumerMap.put(consumerTag, amqpConsumer);
        this.broker.addConsumer((Consumer)amqpConsumer);
        return new ShortString((long)tag.length(), tag.getBytes(StandardCharsets.UTF_8));
    }

    public void close() {
        for (Consumer consumer : this.consumerMap.values()) {
            this.broker.removeConsumer(consumer);
        }
    }

    public void cancelConsumer(ShortString consumerTag) throws AmqpException {
        AmqpConsumer amqpConsumer = this.consumerMap.get(consumerTag);
        if (amqpConsumer == null) {
            throw new AmqpException("Invalid Consumer tag [ " + consumerTag + " ] for the channel: " + this.channelId);
        }
        this.broker.removeConsumer((Consumer)amqpConsumer);
    }

    public InMemoryMessageAggregator getMessageAggregator() {
        return this.messageAggregator;
    }

    public void acknowledge(long deliveryTag, boolean multiple) {
        AckData ackData = this.unackedMessageMap.get(deliveryTag);
        this.broker.acknowledge(ackData.getQueueName(), ackData.getMessage().getMetadata().getInternalId());
    }

    public int getNextConsumerTag() {
        return this.consumerTagGenerator.incrementAndGet();
    }

    public long getNextDeliveryTag() {
        return this.deliveryTagGenerator.incrementAndGet();
    }

    public int getChannelId() {
        return this.channelId;
    }

    public void recordMessageDelivery(long deliveryTag, AckData ackData) {
        this.unackedMessageMap.put(deliveryTag, ackData);
    }
}

