/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.CharsetUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.codec.AmqpMethodDecoder;
import org.wso2.broker.amqp.codec.frames.AmqpBadMessage;
import org.wso2.broker.amqp.codec.frames.ProtocolInitFrame;

public class AmqpDecoder
extends ByteToMessageDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpDecoder.class);
    private static final CharSequence AMQP_PROTOCOL_IDENTIFIER = "AMQP";
    private State currentState = State.PROTOCOL_INITIALIZATION;

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        switch (this.currentState) {
            case PROTOCOL_INITIALIZATION: {
                this.processProtocolInitFrame(buffer, out);
                this.currentState = State.READ_FRAME;
                return;
            }
            case READ_FRAME: {
                AmqpMethodDecoder.parse(buffer, out);
                return;
            }
            case BAD_MESSAGE: {
                buffer.skipBytes(this.actualReadableBytes());
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    private void processProtocolInitFrame(ByteBuf buffer, List<Object> out) {
        if (buffer.readableBytes() >= 8) {
            CharSequence protocolName = buffer.readCharSequence(4, CharsetUtil.US_ASCII);
            buffer.skipBytes(1);
            byte majorVersion = buffer.readByte();
            byte minorVersion = buffer.readByte();
            byte revision = buffer.readByte();
            if (!AMQP_PROTOCOL_IDENTIFIER.equals(protocolName)) {
                out.add(new AmqpBadMessage(new IllegalArgumentException("Unknown protocol name " + protocolName.toString())));
                this.currentState = State.BAD_MESSAGE;
            }
            out.add(new ProtocolInitFrame(majorVersion, minorVersion, revision));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.warn("Exception while handling request", cause);
        this.currentState = State.BAD_MESSAGE;
        ctx.close();
    }

    private static enum State {
        PROTOCOL_INITIALIZATION,
        READ_FRAME,
        BAD_MESSAGE;

    }
}

