/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.codec.AmqpConnectionHandler;
import org.wso2.broker.amqp.codec.data.FieldTable;
import org.wso2.broker.amqp.codec.data.ShortString;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.BasicConsumeOk;
import org.wso2.broker.amqp.codec.frames.MethodFrame;

public class BasicConsume
extends MethodFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicConsume.class);
    private final ShortString queue;
    private final ShortString consumerTag;
    private final boolean noLocal;
    private final boolean noAck;
    private final boolean exclusive;
    private final boolean noWait;
    private final FieldTable arguments;

    public BasicConsume(int channel, ShortString queue, ShortString consumerTag, boolean noLocal, boolean noAck, boolean exclusive, boolean noWait, FieldTable arguments) {
        super(channel, (short)60, (short)20);
        this.queue = queue;
        this.consumerTag = consumerTag;
        this.noLocal = noLocal;
        this.noAck = noAck;
        this.exclusive = exclusive;
        this.noWait = noWait;
        this.arguments = arguments;
    }

    @Override
    protected long getMethodBodySize() {
        return 2L + this.queue.getSize() + this.consumerTag.getSize() + 1L + this.arguments.getSize();
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeShort(0);
        this.queue.write(buf);
        this.consumerTag.write(buf);
        byte flags = 0;
        if (this.noLocal) {
            flags = (byte)(flags | 1);
        }
        if (this.noAck) {
            flags = (byte)(flags | 2);
        }
        if (this.exclusive) {
            flags = (byte)(flags | 4);
        }
        if (this.noWait) {
            flags = (byte)(flags | 8);
        }
        buf.writeByte((int)flags);
        this.arguments.write(buf);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        ctx.writeAndFlush((Object)new BasicConsumeOk(this.getChannel(), this.consumerTag));
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            buf.skipBytes(2);
            ShortString queue = ShortString.parse(buf);
            ShortString consumerTag = ShortString.parse(buf);
            byte flags = buf.readByte();
            boolean noLocal = (flags & 1) == 1;
            boolean noAck = (flags & 2) == 2;
            boolean exclusive = (flags & 4) == 4;
            boolean noWait = (flags & 8) == 8;
            FieldTable arguments = FieldTable.parse(buf);
            return new BasicConsume(channel, queue, consumerTag, noLocal, noAck, exclusive, noWait, arguments);
        };
    }
}

