/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.AckData;
import org.wso2.broker.amqp.AmqpConsumer;
import org.wso2.broker.amqp.AmqpDeliverMessage;
import org.wso2.broker.amqp.AmqpException;
import org.wso2.broker.amqp.codec.InMemoryMessageAggregator;
import org.wso2.broker.common.data.types.FieldTable;
import org.wso2.broker.common.data.types.ShortString;
import org.wso2.broker.core.Broker;
import org.wso2.broker.core.BrokerException;
import org.wso2.broker.core.Consumer;
import org.wso2.broker.core.Message;

public class AmqpChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpChannel.class);
    private final Broker broker;
    private final int channelId;
    private final Map<ShortString, AmqpConsumer> consumerMap;
    private final InMemoryMessageAggregator messageAggregator;
    private AtomicInteger consumerTagGenerator = new AtomicInteger(0);
    private AtomicLong deliveryTagGenerator = new AtomicLong(0L);
    private UnackedMessageMap unackedMessageMap = new UnackedMessageMap();
    private AtomicBoolean flow = new AtomicBoolean(true);
    private AtomicBoolean hasRoom = new AtomicBoolean(true);
    private List<AmqpDeliverMessage> deliveryPendingMessages = new ArrayList<AmqpDeliverMessage>();
    private int prefetchCount;

    public AmqpChannel(Broker broker, int channelId) {
        this.broker = broker;
        this.channelId = channelId;
        this.consumerMap = new HashMap<ShortString, AmqpConsumer>();
        this.messageAggregator = new InMemoryMessageAggregator(broker);
    }

    public void declareExchange(String exchangeName, String exchangeType, boolean passive, boolean durable) throws BrokerException {
        this.broker.createExchange(exchangeName, exchangeType, passive, durable);
    }

    public void declareQueue(ShortString queue, boolean passive, boolean durable, boolean autoDelete) throws BrokerException {
        this.broker.createQueue(queue.toString(), passive, durable, autoDelete);
    }

    public void bind(ShortString queue, ShortString exchange, ShortString routingKey, FieldTable arguments) throws BrokerException {
        this.broker.bind(queue.toString(), exchange.toString(), routingKey.toString(), arguments);
    }

    public ShortString consume(ShortString queueName, ShortString consumerTag, boolean exclusive, ChannelHandlerContext ctx) throws BrokerException {
        ShortString tag = consumerTag;
        if (tag.isEmpty()) {
            tag = ShortString.parseString((String)("sgen" + this.getNextConsumerTag()));
        }
        AmqpConsumer amqpConsumer = new AmqpConsumer(ctx, this, queueName.toString(), tag, exclusive);
        this.consumerMap.put(consumerTag, amqpConsumer);
        this.broker.addConsumer((Consumer)amqpConsumer);
        return tag;
    }

    public void close() {
        for (Consumer consumer : this.consumerMap.values()) {
            this.broker.removeConsumer(consumer);
        }
    }

    public void cancelConsumer(ShortString consumerTag) throws AmqpException {
        AmqpConsumer amqpConsumer = this.consumerMap.get(consumerTag);
        if (amqpConsumer == null) {
            throw new AmqpException("Invalid Consumer tag [ " + consumerTag + " ] for the channel: " + this.channelId);
        }
        this.broker.removeConsumer((Consumer)amqpConsumer);
    }

    public InMemoryMessageAggregator getMessageAggregator() {
        return this.messageAggregator;
    }

    public void acknowledge(long deliveryTag, boolean multiple) {
        AckData ackData = this.unackedMessageMap.remove(deliveryTag);
        if (ackData != null) {
            ackData.getMessage().release();
            this.broker.acknowledge(ackData.getQueueName(), ackData.getMessage().getMetadata().getInternalId());
        } else {
            LOGGER.warn("Could not find a matching ack data for acking the delivery tag " + deliveryTag);
        }
    }

    public int getNextConsumerTag() {
        return this.consumerTagGenerator.incrementAndGet();
    }

    public long getNextDeliveryTag() {
        return this.deliveryTagGenerator.incrementAndGet();
    }

    public int getChannelId() {
        return this.channelId;
    }

    public void recordMessageDelivery(long deliveryTag, AckData ackData) {
        this.unackedMessageMap.put(deliveryTag, ackData);
    }

    public void reject(long deliveryTag, boolean requeue) {
        AckData ackData = this.unackedMessageMap.remove(deliveryTag);
        if (ackData != null) {
            Message message = ackData.getMessage();
            if (requeue) {
                message.setRedeliver();
                this.broker.requeue(ackData.getQueueName(), message);
            } else {
                message.release();
                LOGGER.debug("Dropping message for delivery tag {}", (Object)deliveryTag);
            }
        } else {
            LOGGER.warn("Could not find a matching ack data for rejecting the delivery tag " + deliveryTag);
        }
    }

    public Collection<AckData> recover() {
        return this.unackedMessageMap.clear();
    }

    public void rejectAll() {
        Collection<AckData> entries = this.unackedMessageMap.clear();
        for (AckData ackData : entries) {
            Message message = ackData.getMessage();
            message.setRedeliver();
            this.broker.requeue(ackData.getQueueName(), message);
        }
    }

    public void setFlow(boolean active) {
        this.flow.set(active);
    }

    public boolean isReady() {
        return this.flow.get() && this.hasRoom.get();
    }

    public boolean isFlowEnabled() {
        return this.flow.get();
    }

    public void hold(AmqpDeliverMessage deliverMessage) {
        this.deliveryPendingMessages.add(deliverMessage);
    }

    public List<AmqpDeliverMessage> getPendingMessages() {
        ArrayList<AmqpDeliverMessage> pendingMessages = new ArrayList<AmqpDeliverMessage>(this.deliveryPendingMessages);
        this.deliveryPendingMessages.clear();
        return pendingMessages;
    }

    public void setPrefetchCount(int prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    private class UnackedMessageMap {
        private Map<Long, AckData> unackedMessageMap = new LinkedHashMap<Long, AckData>();

        private UnackedMessageMap() {
        }

        AckData remove(long deliveryTag) {
            AckData ackData = this.unackedMessageMap.remove(deliveryTag);
            if (!AmqpChannel.this.hasRoom.get() && this.unackedMessageMap.size() < AmqpChannel.this.prefetchCount) {
                AmqpChannel.this.hasRoom.set(true);
            }
            return ackData;
        }

        void put(long deliveryTag, AckData ackData) {
            this.unackedMessageMap.put(deliveryTag, ackData);
            if (AmqpChannel.this.hasRoom.get() && this.unackedMessageMap.size() >= AmqpChannel.this.prefetchCount) {
                AmqpChannel.this.hasRoom.set(false);
            }
        }

        Collection<AckData> clear() {
            ArrayList<AckData> entries = new ArrayList<AckData>(this.unackedMessageMap.values());
            this.unackedMessageMap.clear();
            AmqpChannel.this.hasRoom.set(true);
            return entries;
        }
    }
}

