/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.AmqpServerConfiguration;
import org.wso2.broker.amqp.SslHandlerFactory;
import org.wso2.broker.amqp.codec.handlers.AmqpConnectionHandler;
import org.wso2.broker.amqp.codec.handlers.AmqpDecoder;
import org.wso2.broker.amqp.codec.handlers.AmqpEncoder;
import org.wso2.broker.amqp.codec.handlers.AmqpMessageWriter;
import org.wso2.broker.amqp.codec.handlers.BlockingTaskHandler;
import org.wso2.broker.common.BrokerConfigProvider;
import org.wso2.broker.common.StartupContext;
import org.wso2.broker.core.Broker;

public class Server {
    private static final Logger LOGGER = LoggerFactory.getLogger(Server.class);
    private static final int BLOCKING_TASK_EXECUTOR_THREADS = 32;
    private final Broker broker;
    private final AmqpServerConfiguration configuration;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private EventExecutorGroup ioExecutors;
    private Channel plainServerChannel;
    private Channel sslServerChannel;

    public Server(StartupContext context) throws Exception {
        BrokerConfigProvider configProvider = (BrokerConfigProvider)context.getService(BrokerConfigProvider.class);
        this.configuration = (AmqpServerConfiguration)configProvider.getConfigurationObject("transport.amqp", AmqpServerConfiguration.class);
        this.broker = (Broker)context.getService(Broker.class);
        if (this.broker == null) {
            throw new RuntimeException("Could not find the broker class to initialize AMQP server");
        }
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        this.ioExecutors = new DefaultEventExecutorGroup(32);
    }

    private void shutdownExecutors() {
        this.workerGroup.shutdownGracefully();
        this.bossGroup.shutdownGracefully();
        this.ioExecutors.shutdownGracefully();
    }

    private ChannelFuture bindToPlainSocket() throws InterruptedException {
        String hostname = this.configuration.getPlain().getHostName();
        int port = Integer.parseInt(this.configuration.getPlain().getPort());
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new SocketChannelInitializer(this.ioExecutors)).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        ChannelFuture future = b.bind(hostname, port).sync();
        LOGGER.info("Listening AMQP on " + hostname + ":" + port);
        return future;
    }

    private ChannelFuture bindToSslSocket() throws InterruptedException, CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        String hostname = this.configuration.getSsl().getHostName();
        int port = Integer.parseInt(this.configuration.getSsl().getPort());
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new SslSocketChannelInitializer(this.ioExecutors, new SslHandlerFactory(this.configuration))).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        ChannelFuture future = b.bind(hostname, port).sync();
        LOGGER.info("Listening AMQP/" + this.configuration.getSsl().getProtocol() + " on " + hostname + ":" + port);
        return future;
    }

    public void start() throws InterruptedException, CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        ChannelFuture channelFuture = this.bindToPlainSocket();
        this.plainServerChannel = channelFuture.channel();
        if (this.configuration.getSsl().isEnabled()) {
            ChannelFuture sslSocketFuture = this.bindToSslSocket();
            this.sslServerChannel = sslSocketFuture.channel();
        }
    }

    public void awaitServerClose() throws InterruptedException {
        try {
            this.plainServerChannel.closeFuture().sync();
            if (this.sslServerChannel != null) {
                this.sslServerChannel.closeFuture().sync();
            }
        }
        finally {
            this.shutdownExecutors();
        }
    }

    public void stop() throws InterruptedException {
        try {
            this.plainServerChannel.close().sync();
            if (this.sslServerChannel != null) {
                this.sslServerChannel.close().sync();
            }
        }
        finally {
            this.shutdownExecutors();
        }
    }

    private class SslSocketChannelInitializer
    extends ChannelInitializer<SocketChannel> {
        private final EventExecutorGroup ioExecutors;
        private final SslHandlerFactory sslHandlerFactory;

        public SslSocketChannelInitializer(EventExecutorGroup ioExecutors, SslHandlerFactory sslHandlerFactory) {
            this.ioExecutors = ioExecutors;
            this.sslHandlerFactory = sslHandlerFactory;
        }

        protected void initChannel(SocketChannel socketChannel) {
            socketChannel.pipeline().addLast(new ChannelHandler[]{this.sslHandlerFactory.create()}).addLast(new ChannelHandler[]{new AmqpDecoder()}).addLast(new ChannelHandler[]{new AmqpEncoder()}).addLast(new ChannelHandler[]{new AmqpConnectionHandler(Server.this.broker)}).addLast(this.ioExecutors, new ChannelHandler[]{new AmqpMessageWriter()}).addLast(this.ioExecutors, new ChannelHandler[]{new BlockingTaskHandler()});
        }
    }

    private class SocketChannelInitializer
    extends ChannelInitializer<SocketChannel> {
        private final EventExecutorGroup ioExecutors;

        public SocketChannelInitializer(EventExecutorGroup ioExecutors) {
            this.ioExecutors = ioExecutors;
        }

        protected void initChannel(SocketChannel socketChannel) {
            socketChannel.pipeline().addLast(new ChannelHandler[]{new AmqpDecoder()}).addLast(new ChannelHandler[]{new AmqpEncoder()}).addLast(new ChannelHandler[]{new AmqpConnectionHandler(Server.this.broker)}).addLast(this.ioExecutors, new ChannelHandler[]{new AmqpMessageWriter()}).addLast(this.ioExecutors, new ChannelHandler[]{new BlockingTaskHandler()});
        }
    }
}

