/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.AmqpDeliverMessage;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.ChannelFlowOk;
import org.wso2.broker.amqp.codec.frames.MethodFrame;
import org.wso2.broker.amqp.codec.handlers.AmqpConnectionHandler;

public class ChannelFlow
extends MethodFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelFlow.class);
    private final boolean active;

    public ChannelFlow(int channel, boolean active) {
        super(channel, (short)20, (short)20);
        this.active = active;
    }

    @Override
    protected long getMethodBodySize() {
        return 1L;
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeBoolean(this.active);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        connectionHandler.getChannel(this.getChannel()).setFlow(this.active);
        ctx.writeAndFlush((Object)new ChannelFlowOk(this.getChannel(), this.active));
        if (this.active) {
            List<AmqpDeliverMessage> pendingMessages = connectionHandler.getChannel(this.getChannel()).getPendingMessages();
            for (AmqpDeliverMessage message : pendingMessages) {
                ctx.channel().write((Object)message);
            }
        }
        ctx.flush();
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            boolean active = buf.readBoolean();
            return new ChannelFlow(channel, active);
        };
    }
}

