/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.ConnectionClose;
import org.wso2.broker.amqp.codec.frames.ConnectionSecure;
import org.wso2.broker.amqp.codec.frames.ConnectionTune;
import org.wso2.broker.amqp.codec.frames.MethodFrame;
import org.wso2.broker.amqp.codec.handlers.AmqpConnectionHandler;
import org.wso2.broker.common.data.types.FieldTable;
import org.wso2.broker.common.data.types.LongString;
import org.wso2.broker.common.data.types.ShortString;
import org.wso2.broker.core.Broker;
import org.wso2.broker.core.security.authentication.sasl.SaslServerBuilder;

public class ConnectionStartOk
extends MethodFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionStartOk.class);
    private final FieldTable clientProperties;
    private final ShortString mechanism;
    private final ShortString locale;
    private final LongString response;

    public ConnectionStartOk(int channel, FieldTable clientProperties, ShortString mechanisms, ShortString locale, LongString response) {
        super(channel, (short)10, (short)11);
        this.clientProperties = clientProperties;
        this.mechanism = mechanisms;
        this.locale = locale;
        this.response = response;
    }

    @Override
    protected long getMethodBodySize() {
        return this.clientProperties.getSize() + this.mechanism.getSize() + this.locale.getSize() + this.response.getSize();
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        this.clientProperties.write(buf);
        this.mechanism.write(buf);
        this.locale.write(buf);
        this.response.write(buf);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        ctx.fireChannelRead(() -> {
            block7: {
                Broker broker = connectionHandler.getBroker();
                SaslServerBuilder saslServerBuilder = (SaslServerBuilder)broker.getAuthenticationManager().getSaslMechanisms().get(this.mechanism.toString());
                try {
                    if (saslServerBuilder == null) {
                        throw new SaslException("Server does not support for mechanism: " + this.mechanism);
                    }
                    SaslServer saslServer = Sasl.createSaslServer(this.mechanism.toString(), "AMQP", connectionHandler.getConfiguration().getHostName(), saslServerBuilder.getProperties(), saslServerBuilder.getCallbackHandler());
                    connectionHandler.setSaslServer(saslServer);
                    if (saslServer != null) {
                        byte[] challenge = saslServer.evaluateResponse(this.response.getBytes());
                        if (saslServer.isComplete()) {
                            ctx.writeAndFlush((Object)new ConnectionTune(256, 65535L, 0));
                        } else {
                            ctx.writeAndFlush((Object)new ConnectionSecure(this.getChannel(), LongString.parse((byte[])challenge)));
                        }
                        break block7;
                    }
                    throw new SaslException("Sasl server cannot be found for mechanism: " + this.mechanism);
                }
                catch (SaslException e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Exception occurred while authenticating incoming connection ", (Throwable)e);
                    }
                    String replyText = "Authentication Failed";
                    ctx.writeAndFlush((Object)new ConnectionClose(403, ShortString.parseString((String)replyText), 10, 11));
                }
            }
        });
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            FieldTable clientProperties = FieldTable.parse((ByteBuf)buf);
            ShortString mechanism = ShortString.parse((ByteBuf)buf);
            LongString response = LongString.parse((ByteBuf)buf);
            ShortString locale = ShortString.parse((ByteBuf)buf);
            return new ConnectionStartOk(channel, clientProperties, mechanism, locale, response);
        };
    }
}

