/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp;

import io.netty.channel.ChannelHandlerContext;
import org.wso2.broker.amqp.AckData;
import org.wso2.broker.amqp.codec.AmqpChannel;
import org.wso2.broker.amqp.codec.frames.BasicDeliver;
import org.wso2.broker.amqp.codec.frames.ContentFrame;
import org.wso2.broker.amqp.codec.frames.HeaderFrame;
import org.wso2.broker.common.data.types.ShortString;
import org.wso2.broker.core.ContentChunk;
import org.wso2.broker.core.Message;
import org.wso2.broker.core.Metadata;
import org.wso2.broker.core.util.MessageTracer;
import org.wso2.broker.core.util.TraceField;

public class AmqpDeliverMessage {
    private static final String SEND_MESSAGE = "Delivering message to client from AMQP transport.";
    private static final String SENT_ON_HOLD = "Message delivery on hold. Flow disabled.";
    private static final String QUEUE_NAME_FIELD = "queueName";
    private static final String CONSUMER_ADDRESS_FIELD = "consumerAddress";
    private final ShortString consumerTag;
    private final AmqpChannel channel;
    private final Message message;
    private final String queueName;

    public AmqpDeliverMessage(Message message, ShortString consumerTag, AmqpChannel channel, String queueName) {
        this.message = message;
        this.consumerTag = consumerTag;
        this.channel = channel;
        this.queueName = queueName;
    }

    public void write(ChannelHandlerContext ctx) {
        if (!this.channel.isFlowEnabled()) {
            this.channel.hold(this);
            if (MessageTracer.isTraceEnabled()) {
                MessageTracer.trace((Message)this.message, (String)SENT_ON_HOLD, (TraceField[])new TraceField[]{new TraceField("consumerTag", (Object)this.consumerTag), new TraceField("channelId", (Object)this.channel.getChannelId()), new TraceField(QUEUE_NAME_FIELD, (Object)this.queueName), new TraceField(CONSUMER_ADDRESS_FIELD, (Object)ctx.channel().remoteAddress())});
            }
        } else {
            long deliveryTag = this.channel.getNextDeliveryTag();
            this.channel.recordMessageDelivery(deliveryTag, new AckData(this.message.shallowCopy(), this.queueName, this.consumerTag));
            Metadata metadata = this.message.getMetadata();
            BasicDeliver basicDeliverFrame = new BasicDeliver(this.channel.getChannelId(), this.consumerTag, deliveryTag, this.message.isRedelivered(), ShortString.parseString((String)metadata.getExchangeName()), ShortString.parseString((String)metadata.getRoutingKey()));
            HeaderFrame headerFrame = new HeaderFrame(this.channel.getChannelId(), 60, metadata.getContentLength());
            headerFrame.setProperties(metadata.getProperties());
            headerFrame.setHeaders(metadata.getHeaders());
            ctx.write((Object)basicDeliverFrame);
            ctx.write((Object)headerFrame);
            for (ContentChunk chunk : this.message.getContentChunks()) {
                ContentFrame contentFrame = new ContentFrame(this.channel.getChannelId(), chunk.getBytes().capacity(), chunk.getBytes());
                ctx.write((Object)contentFrame);
            }
            if (MessageTracer.isTraceEnabled()) {
                MessageTracer.trace((Message)this.message, (String)SEND_MESSAGE, (TraceField[])new TraceField[]{new TraceField("deliveryTag", (Object)deliveryTag), new TraceField("channelId", (Object)this.channel.getChannelId()), new TraceField(QUEUE_NAME_FIELD, (Object)this.queueName), new TraceField("consumerTag", (Object)this.consumerTag), new TraceField(CONSUMER_ADDRESS_FIELD, (Object)ctx.channel().remoteAddress())});
            }
        }
    }

    public AmqpChannel getChannel() {
        return this.channel;
    }
}

