/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.AmqpDeliverMessage;
import org.wso2.broker.amqp.codec.AmqpChannel;
import org.wso2.broker.common.data.types.ShortString;
import org.wso2.broker.core.Consumer;
import org.wso2.broker.core.Message;
import org.wso2.broker.core.util.MessageTracer;
import org.wso2.broker.core.util.TraceField;

public class AmqpConsumer
extends Consumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpConsumer.class);
    public static final String CONSUMER_TAG_FIELD_NAME = "consumerTag";
    private final String queueName;
    private final ShortString consumerTag;
    private final boolean isExclusive;
    private final ChannelHandlerContext context;
    private final AmqpChannel channel;
    private ChannelFutureListener errorLogger;
    private final List<TraceField> tracingProperties;

    public AmqpConsumer(ChannelHandlerContext ctx, AmqpChannel channel, String queueName, ShortString consumerTag, boolean isExclusive) {
        this.queueName = queueName;
        this.consumerTag = consumerTag;
        this.isExclusive = isExclusive;
        this.context = ctx;
        this.channel = channel;
        this.errorLogger = new ErrorLogger(queueName);
        this.tracingProperties = new ArrayList<TraceField>(2);
        this.tracingProperties.add(new TraceField("channelId", (Object)channel.getChannelId()));
        this.tracingProperties.add(new TraceField(CONSUMER_TAG_FIELD_NAME, (Object)consumerTag));
    }

    public void send(Message message) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Adding message to AMQP Netty outbound; messageId: {}, consumerTag: {}, queueName: {}", new Object[]{message.getMetadata().getInternalId(), this.consumerTag, this.queueName});
        }
        AmqpDeliverMessage deliverMessage = this.channel.createDeliverMessage(message, this.consumerTag, this.queueName);
        ChannelFutureListener channelListener = MessageTracer.isTraceEnabled() ? new TracingChannelFutureListener(message, this) : this.errorLogger;
        ChannelFuture channelFuture = this.context.channel().writeAndFlush((Object)deliverMessage);
        channelFuture.addListener((GenericFutureListener)channelListener);
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void close() {
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    public boolean isReady() {
        return this.channel.isReady();
    }

    public String toString() {
        return "AmqpConsumer{queueName='" + this.queueName + '\'' + ", consumerTag=" + this.consumerTag + ", isExclusive=" + this.isExclusive + '}';
    }

    private class TracingChannelFutureListener
    implements ChannelFutureListener {
        private static final String TRANSPORT_DELIVERY_FAILURE = "Message delivery failed. AMQP transport error.";
        private static final String SENT_FROM_TRANSPORT = "Message sent from transport.";
        private final Message message;
        private final AmqpConsumer consumer;

        TracingChannelFutureListener(Message message, AmqpConsumer consumer) {
            this.message = message;
            this.consumer = consumer;
        }

        public void operationComplete(ChannelFuture channelFuture) {
            if (channelFuture.isSuccess()) {
                MessageTracer.trace((Message)this.message, (Consumer)this.consumer, (String)SENT_FROM_TRANSPORT, (List)AmqpConsumer.this.tracingProperties);
            } else {
                LOGGER.warn("Error while sending message for " + AmqpConsumer.this.queueName, channelFuture.cause());
                MessageTracer.trace((Message)this.message, (Consumer)this.consumer, (String)TRANSPORT_DELIVERY_FAILURE, (List)AmqpConsumer.this.tracingProperties);
            }
        }
    }

    private static class ErrorLogger
    implements ChannelFutureListener {
        private final String queueName;

        private ErrorLogger(String queueName) {
            this.queueName = queueName;
        }

        public void operationComplete(ChannelFuture future) {
            if (!future.isSuccess()) {
                LOGGER.warn("Error while sending message for " + this.queueName, future.cause());
            }
        }
    }
}

