/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.handlers;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.security.sasl.SaslServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.AmqpServerConfiguration;
import org.wso2.broker.amqp.codec.AmqpChannel;
import org.wso2.broker.amqp.codec.ConnectionException;
import org.wso2.broker.amqp.codec.frames.AmqpBadMessage;
import org.wso2.broker.amqp.codec.frames.ConnectionStart;
import org.wso2.broker.amqp.codec.frames.GeneralFrame;
import org.wso2.broker.amqp.codec.frames.ProtocolInitFrame;
import org.wso2.broker.amqp.metrics.AmqpMetricManager;
import org.wso2.broker.core.Broker;

public class AmqpConnectionHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpConnectionHandler.class);
    private final Map<Integer, AmqpChannel> channels = new HashMap<Integer, AmqpChannel>();
    private final AmqpServerConfiguration configuration;
    private final Broker broker;
    private final AmqpMetricManager metricManager;
    private SaslServer saslServer = null;

    public AmqpConnectionHandler(AmqpServerConfiguration configuration, Broker broker, AmqpMetricManager metricManager) {
        this.configuration = configuration;
        this.broker = broker;
        this.metricManager = metricManager;
        metricManager.incrementConnectionCount();
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        ctx.channel().closeFuture().addListener(future -> ctx.fireChannelRead(this::onConnectionClose));
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ProtocolInitFrame) {
            this.handleProtocolInit(ctx, (ProtocolInitFrame)msg);
        } else if (msg instanceof GeneralFrame) {
            ((GeneralFrame)msg).handle(ctx, this);
        } else if (msg instanceof AmqpBadMessage) {
            LOGGER.warn("Bad message received", ((AmqpBadMessage)msg).getCause());
            ctx.close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.warn("Exception while handling request", cause);
        ctx.close();
    }

    private void onConnectionClose() {
        this.closeAllChannels();
        this.metricManager.decrementConnectionCount();
    }

    private void handleProtocolInit(ChannelHandlerContext ctx, ProtocolInitFrame msg) {
        if (ProtocolInitFrame.V_091.equals(msg)) {
            ctx.writeAndFlush((Object)ConnectionStart.DEFAULT_FRAME);
        } else {
            ctx.writeAndFlush((Object)ProtocolInitFrame.V_091);
        }
    }

    public void createChannel(int channelId) throws ConnectionException {
        AmqpChannel channel = this.channels.get(channelId);
        if (channel != null) {
            throw new ConnectionException(504, "Channel ID " + channelId + " Already exists");
        }
        this.channels.put(channelId, new AmqpChannel(this.configuration, this.broker, channelId, this.metricManager));
        this.metricManager.incrementChannelCount();
    }

    public AmqpChannel getChannel(int channelId) {
        return this.channels.get(channelId);
    }

    public void closeChannel(int channelId) {
        AmqpChannel channel = this.channels.remove(channelId);
        if (Objects.nonNull(channel)) {
            this.closeChannel(channel);
        }
    }

    private void closeChannel(AmqpChannel channel) {
        this.metricManager.decrementChannelCount();
        channel.close();
    }

    public void closeAllChannels() {
        for (AmqpChannel channel : this.channels.values()) {
            this.closeChannel(channel);
        }
        this.channels.clear();
    }

    public Broker getBroker() {
        return this.broker;
    }

    public AmqpServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setSaslServer(SaslServer saslServer) {
        this.saslServer = saslServer;
    }

    public SaslServer getSaslServer() {
        return this.saslServer;
    }
}

