/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.AckData;
import org.wso2.broker.amqp.AmqpConsumer;
import org.wso2.broker.amqp.AmqpDeliverMessage;
import org.wso2.broker.amqp.AmqpServerConfiguration;
import org.wso2.broker.amqp.codec.ChannelException;
import org.wso2.broker.amqp.codec.InMemoryMessageAggregator;
import org.wso2.broker.amqp.codec.flow.ChannelFlowManager;
import org.wso2.broker.amqp.metrics.AmqpMetricManager;
import org.wso2.broker.common.data.types.FieldTable;
import org.wso2.broker.common.data.types.ShortString;
import org.wso2.broker.core.Broker;
import org.wso2.broker.core.BrokerException;
import org.wso2.broker.core.Consumer;
import org.wso2.broker.core.Message;
import org.wso2.broker.core.util.MessageTracer;
import org.wso2.broker.core.util.TraceField;

public class AmqpChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpChannel.class);
    private static final String ACKNOWLEDGE_RECEIVED = "Acknowledgement received from AMQP transport.";
    private static final String UNKNOWN_ACKNOWLEDGEMENT = "Matching message for acknowledgment not found.";
    private static final String REJECT_RECEIVED = "Message reject received from AMQP transport.";
    private static final String UNKNOWN_REJECT = "Matching message for reject not found.";
    public static final String DELIVERY_TAG_FIELD_NAME = "deliveryTag";
    public static final String CHANNEL_ID_FIELD_NAME = "channelId";
    private static final String REQUEUE_FLAG_FIELD_NAME = "requeueFlag";
    private final Broker broker;
    private final int channelId;
    private final AmqpMetricManager metricManager;
    private final Map<ShortString, AmqpConsumer> consumerMap;
    private final InMemoryMessageAggregator messageAggregator;
    private final ChannelFlowManager flowManager;
    private final int maxRedeliveryCount;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private AtomicInteger consumerTagGenerator = new AtomicInteger(0);
    private AtomicLong deliveryTagGenerator = new AtomicLong(0L);
    private UnackedMessageMap unackedMessageMap = new UnackedMessageMap();
    private AtomicBoolean flow = new AtomicBoolean(true);
    private AtomicBoolean hasRoom = new AtomicBoolean(true);
    private List<AmqpDeliverMessage> deliveryPendingMessages = new ArrayList<AmqpDeliverMessage>();
    private final TraceField traceChannelIdField;
    private int prefetchCount;

    public AmqpChannel(AmqpServerConfiguration configuration, Broker broker, int channelId, AmqpMetricManager metricManager) {
        this.broker = broker;
        this.channelId = channelId;
        this.metricManager = metricManager;
        this.consumerMap = new HashMap<ShortString, AmqpConsumer>();
        this.messageAggregator = new InMemoryMessageAggregator(broker);
        this.flowManager = new ChannelFlowManager(this, configuration.getChannelFlow().getLowLimit(), configuration.getChannelFlow().getHighLimit());
        this.maxRedeliveryCount = Integer.parseInt(configuration.getMaxRedeliveryCount());
        this.traceChannelIdField = new TraceField(CHANNEL_ID_FIELD_NAME, (Object)channelId);
    }

    public void declareExchange(String exchangeName, String exchangeType, boolean passive, boolean durable) throws BrokerException {
        this.broker.createExchange(exchangeName, exchangeType, passive, durable);
    }

    public void declareQueue(ShortString queue, boolean passive, boolean durable, boolean autoDelete) throws BrokerException {
        this.broker.createQueue(queue.toString(), passive, durable, autoDelete);
    }

    public void bind(ShortString queue, ShortString exchange, ShortString routingKey, FieldTable arguments) throws BrokerException {
        this.broker.bind(queue.toString(), exchange.toString(), routingKey.toString(), arguments);
    }

    public ShortString consume(ShortString queueName, ShortString consumerTag, boolean exclusive, ChannelHandlerContext ctx) throws BrokerException {
        ShortString tag = consumerTag;
        if (tag.isEmpty()) {
            tag = ShortString.parseString((String)("sgen" + this.getNextConsumerTag()));
        }
        AmqpConsumer amqpConsumer = new AmqpConsumer(ctx, this, queueName.toString(), tag, exclusive);
        this.consumerMap.put(consumerTag, amqpConsumer);
        this.broker.addConsumer((Consumer)amqpConsumer);
        this.metricManager.incrementConsumerCount();
        return tag;
    }

    public void close() {
        this.closed.set(true);
        for (Consumer consumer : this.consumerMap.values()) {
            this.closeConsumer(consumer);
        }
        this.consumerMap.clear();
        this.requeueUnackedMessages();
    }

    private void requeueUnackedMessages() {
        Collection<AckData> ackDataList = this.unackedMessageMap.clear();
        for (AckData ackData : ackDataList) {
            Message message = ackData.getMessage();
            String queueName = ackData.getQueueName();
            try {
                this.broker.requeue(queueName, message);
            }
            catch (BrokerException e) {
                LOGGER.error("Error while requeueing message {} for queue ()", new Object[]{message, queueName, e});
            }
        }
    }

    public void cancelConsumer(ShortString consumerTag) throws ChannelException {
        AmqpConsumer amqpConsumer = this.consumerMap.remove(consumerTag);
        if (amqpConsumer == null) {
            throw new ChannelException(404, "Invalid Consumer tag [ " + consumerTag + " ] for the channel: " + this.channelId);
        }
        this.closeConsumer(amqpConsumer);
    }

    private void closeConsumer(Consumer consumer) {
        try {
            this.broker.removeConsumer(consumer);
        }
        finally {
            this.metricManager.decrementConsumerCount();
        }
    }

    public InMemoryMessageAggregator getMessageAggregator() {
        return this.messageAggregator;
    }

    public void acknowledge(long deliveryTag, boolean multiple) throws BrokerException {
        AckData ackData = this.unackedMessageMap.remove(deliveryTag);
        if (MessageTracer.isTraceEnabled()) {
            String description = Objects.nonNull(ackData) ? ACKNOWLEDGE_RECEIVED : UNKNOWN_ACKNOWLEDGEMENT;
            MessageTracer.trace((String)description, (TraceField[])new TraceField[]{this.traceChannelIdField, new TraceField(DELIVERY_TAG_FIELD_NAME, (Object)deliveryTag)});
        }
        if (ackData != null) {
            ackData.getMessage().release();
            this.broker.acknowledge(ackData.getQueueName(), ackData.getMessage());
        } else {
            LOGGER.warn("Could not find a matching ack data for acking the delivery tag " + deliveryTag);
        }
    }

    public int getNextConsumerTag() {
        return this.consumerTagGenerator.incrementAndGet();
    }

    public long getNextDeliveryTag() {
        return this.deliveryTagGenerator.incrementAndGet();
    }

    public int getChannelId() {
        return this.channelId;
    }

    public void recordMessageDelivery(long deliveryTag, AckData ackData) {
        this.unackedMessageMap.put(deliveryTag, ackData);
    }

    public void reject(long deliveryTag, boolean requeue) throws BrokerException {
        this.metricManager.markReject();
        AckData ackData = this.unackedMessageMap.remove(deliveryTag);
        if (MessageTracer.isTraceEnabled()) {
            String description = Objects.nonNull(ackData) ? REJECT_RECEIVED : UNKNOWN_REJECT;
            MessageTracer.trace((String)description, (TraceField[])new TraceField[]{this.traceChannelIdField, new TraceField(DELIVERY_TAG_FIELD_NAME, (Object)deliveryTag), new TraceField(REQUEUE_FLAG_FIELD_NAME, (Object)requeue)});
        }
        if (ackData != null) {
            Message message = ackData.getMessage();
            if (requeue) {
                this.setRedeliverAndRequeue(message, ackData.getQueueName());
            } else {
                message.release();
                LOGGER.debug("Dropping message for delivery tag {}", (Object)deliveryTag);
            }
        } else {
            LOGGER.warn("Could not find a matching ack data for rejecting the delivery tag " + deliveryTag);
        }
    }

    private void setRedeliverAndRequeue(Message message, String queueName) throws BrokerException {
        int redeliveryCount = message.setRedeliver();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Redelivery count is {} for message {}", (Object)redeliveryCount, (Object)message.getMetadata().getInternalId());
        }
        if (redeliveryCount <= this.maxRedeliveryCount) {
            this.broker.requeue(queueName, message);
        } else {
            this.broker.moveToDlc(queueName, message);
        }
    }

    public Collection<AckData> recover() {
        return this.unackedMessageMap.clear();
    }

    public void requeueAll() throws BrokerException {
        Collection<AckData> entries = this.unackedMessageMap.clear();
        for (AckData ackData : entries) {
            this.broker.requeue(ackData.getQueueName(), ackData.getMessage());
        }
    }

    public void setFlow(boolean active) {
        this.flow.set(active);
    }

    public boolean isReady() {
        return this.flow.get() && this.hasRoom.get() && !this.closed.get();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isFlowEnabled() {
        return this.flow.get();
    }

    public ChannelFlowManager getFlowManager() {
        return this.flowManager;
    }

    public void hold(AmqpDeliverMessage deliverMessage) {
        this.deliveryPendingMessages.add(deliverMessage);
    }

    public List<AmqpDeliverMessage> getPendingMessages() {
        ArrayList<AmqpDeliverMessage> pendingMessages = new ArrayList<AmqpDeliverMessage>(this.deliveryPendingMessages);
        this.deliveryPendingMessages.clear();
        return pendingMessages;
    }

    public void setPrefetchCount(int prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public AmqpDeliverMessage createDeliverMessage(Message message, ShortString consumerTag, String queueName) {
        return new AmqpDeliverMessage(message, consumerTag, this, queueName, this.broker);
    }

    private class UnackedMessageMap {
        private Map<Long, AckData> unackedMessageMap = new LinkedHashMap<Long, AckData>();

        private UnackedMessageMap() {
        }

        AckData remove(long deliveryTag) {
            AckData ackData = this.unackedMessageMap.remove(deliveryTag);
            if (!AmqpChannel.this.hasRoom.get() && this.unackedMessageMap.size() < AmqpChannel.this.prefetchCount) {
                AmqpChannel.this.hasRoom.set(true);
            }
            return ackData;
        }

        void put(long deliveryTag, AckData ackData) {
            this.unackedMessageMap.put(deliveryTag, ackData);
            if (AmqpChannel.this.hasRoom.get() && this.unackedMessageMap.size() >= AmqpChannel.this.prefetchCount) {
                AmqpChannel.this.hasRoom.set(false);
            }
        }

        Collection<AckData> clear() {
            ArrayList<AckData> entries = new ArrayList<AckData>(this.unackedMessageMap.values());
            this.unackedMessageMap.clear();
            AmqpChannel.this.hasRoom.set(true);
            return entries;
        }
    }
}

