/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.AckData;
import org.wso2.broker.amqp.codec.AmqpChannel;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.BasicRecoveryOk;
import org.wso2.broker.amqp.codec.frames.MethodFrame;
import org.wso2.broker.amqp.codec.handlers.AmqpConnectionHandler;
import org.wso2.broker.core.Message;

public class BasicRecover
extends MethodFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicRecover.class);
    private final boolean requeue;

    public BasicRecover(int channel, boolean requeue) {
        super(channel, (short)60, (short)110);
        this.requeue = requeue;
    }

    @Override
    protected long getMethodBodySize() {
        return 1L;
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeBoolean(this.requeue);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        AmqpChannel channel = connectionHandler.getChannel(this.getChannel());
        if (this.isRequeue()) {
            ctx.fireChannelRead(() -> {
                channel.requeueAll();
                ctx.writeAndFlush((Object)new BasicRecoveryOk(this.getChannel()));
            });
        } else {
            ctx.fireChannelRead(() -> {
                Channel nettyChannel = ctx.channel();
                nettyChannel.write((Object)new BasicRecoveryOk(this.getChannel()));
                Collection<AckData> unackedMessages = channel.recover();
                for (AckData ackData : unackedMessages) {
                    Message message = ackData.getMessage();
                    nettyChannel.write((Object)channel.createDeliverMessage(message, ackData.getConsumerTag(), ackData.getQueueName()));
                }
                nettyChannel.flush();
            });
        }
    }

    public boolean isRequeue() {
        return this.requeue;
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            boolean noWait = buf.readBoolean();
            return new BasicRecover(channel, noWait);
        };
    }
}

