/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.wso2.broker.amqp.codec.AmqpChannel;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.ChannelClose;
import org.wso2.broker.amqp.codec.frames.ExchangeDeclareOk;
import org.wso2.broker.amqp.codec.frames.MethodFrame;
import org.wso2.broker.amqp.codec.handlers.AmqpConnectionHandler;
import org.wso2.broker.common.ValidationException;
import org.wso2.broker.common.data.types.FieldTable;
import org.wso2.broker.common.data.types.ShortString;
import org.wso2.broker.core.BrokerException;

public class ExchangeDeclare
extends MethodFrame {
    private static final short CLASS_ID = 40;
    private static final short METHOD_ID = 10;
    private final ShortString exchange;
    private final ShortString type;
    private final boolean passive;
    private final boolean durable;
    private final boolean noWait;
    private final FieldTable arguments;

    public ExchangeDeclare(int channel, ShortString exchange, ShortString type, boolean passive, boolean durable, boolean noWait, FieldTable arguments) {
        super(channel, (short)40, (short)10);
        this.exchange = exchange;
        this.type = type;
        this.passive = passive;
        this.durable = durable;
        this.noWait = noWait;
        this.arguments = arguments;
    }

    @Override
    protected long getMethodBodySize() {
        return 2L + this.exchange.getSize() + this.type.getSize() + 1L + this.arguments.getSize();
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeShort(0);
        this.exchange.write(buf);
        this.type.write(buf);
        byte flags = 0;
        if (this.passive) {
            flags = (byte)(flags | 1);
        }
        if (this.durable) {
            flags = (byte)(flags | 2);
        }
        if (this.noWait) {
            flags = (byte)(flags | 0x10);
        }
        buf.writeByte((int)flags);
        this.arguments.write(buf);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        AmqpChannel channel = connectionHandler.getChannel(this.getChannel());
        ctx.fireChannelRead(() -> {
            try {
                channel.declareExchange(this.exchange.toString(), this.type.toString(), this.passive, this.durable);
                ctx.writeAndFlush((Object)new ExchangeDeclareOk(this.getChannel()));
            }
            catch (BrokerException e) {
                ctx.writeAndFlush((Object)new ChannelClose(this.getChannel(), 530, ShortString.parseString((String)e.getMessage()), 40, 10));
            }
            catch (ValidationException e) {
                ctx.writeAndFlush((Object)new ChannelClose(this.getChannel(), 406, ShortString.parseString((String)e.getMessage()), 40, 10));
            }
        });
    }

    public ShortString getExchange() {
        return this.exchange;
    }

    public ShortString getType() {
        return this.type;
    }

    public boolean isPassive() {
        return this.passive;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public boolean isNoWait() {
        return this.noWait;
    }

    public FieldTable getArguments() {
        return this.arguments;
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            buf.skipBytes(2);
            ShortString exchange = ShortString.parse((ByteBuf)buf);
            ShortString type = ShortString.parse((ByteBuf)buf);
            byte flags = buf.readByte();
            boolean passive = (flags & 1) == 1;
            boolean durable = (flags & 2) == 2;
            boolean noWait = (flags & 0x10) == 16;
            FieldTable arguments = FieldTable.parse((ByteBuf)buf);
            return new ExchangeDeclare(channel, exchange, type, passive, durable, noWait, arguments);
        };
    }
}

