/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.AmqpDeliverMessage;
import org.wso2.broker.amqp.codec.AmqpChannel;
import org.wso2.broker.common.data.types.ShortString;
import org.wso2.broker.core.Consumer;
import org.wso2.broker.core.Message;

public class AmqpConsumer
implements Consumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpConsumer.class);
    private final String queueName;
    private final ShortString consumerTag;
    private final boolean isExclusive;
    private final ChannelHandlerContext context;
    private final AmqpChannel channel;
    private ChannelFutureListener errorLogger;

    public AmqpConsumer(ChannelHandlerContext ctx, AmqpChannel channel, String queueName, ShortString consumerTag, boolean isExclusive) {
        this.queueName = queueName;
        this.consumerTag = consumerTag;
        this.isExclusive = isExclusive;
        this.context = ctx;
        this.channel = channel;
        this.errorLogger = new ErrorLogger(queueName);
    }

    public void send(Message message) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Adding message to AMQP Netty outbound; messageId: {}, consumerTag: {}, queueName: {}", new Object[]{message.getMetadata().getInternalId(), this.consumerTag, this.queueName});
        }
        AmqpDeliverMessage deliverMessage = new AmqpDeliverMessage(message, this.consumerTag, this.channel, this.queueName);
        ChannelFuture channelFuture = this.context.channel().writeAndFlush((Object)deliverMessage);
        channelFuture.addListener((GenericFutureListener)this.errorLogger);
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void close() {
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    public boolean isReady() {
        return this.channel.isReady();
    }

    public String toString() {
        return "AmqpConsumer{queueName='" + this.queueName + '\'' + ", consumerTag=" + this.consumerTag + ", isExclusive=" + this.isExclusive + '}';
    }

    private static class ErrorLogger
    implements ChannelFutureListener {
        private final String queueName;

        private ErrorLogger(String queueName) {
            this.queueName = queueName;
        }

        public void operationComplete(ChannelFuture future) {
            if (!future.isSuccess()) {
                LOGGER.warn("Error while sending message for " + this.queueName, future.cause());
            }
        }
    }
}

