/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.metrics;

import org.wso2.broker.amqp.Server;
import org.wso2.broker.amqp.metrics.AmqpMetricManager;
import org.wso2.carbon.metrics.core.Counter;
import org.wso2.carbon.metrics.core.Level;
import org.wso2.carbon.metrics.core.Meter;
import org.wso2.carbon.metrics.core.MetricService;

public class DefaultAmqpMetricManager
implements AmqpMetricManager {
    private final Counter totalChannelCounter;
    private final Counter totalConnectionCounter;
    private final Counter totalConsumerCounter;
    private final Meter rejectMeter;

    public DefaultAmqpMetricManager(MetricService metrics) {
        this.totalChannelCounter = metrics.counter(MetricService.name(Server.class, (String[])new String[]{"node", "totalChannels"}), Level.INFO, new Level[0]);
        this.totalConnectionCounter = metrics.counter(MetricService.name(Server.class, (String[])new String[]{"node", "totalConnections"}), Level.INFO, new Level[0]);
        this.totalConsumerCounter = metrics.counter(MetricService.name(Server.class, (String[])new String[]{"node", "totalConsumers"}), Level.INFO, new Level[0]);
        this.rejectMeter = metrics.meter(MetricService.name(Server.class, (String[])new String[]{"node", "messageRejects"}), Level.INFO, new Level[0]);
    }

    @Override
    public void incrementChannelCount() {
        this.totalChannelCounter.inc();
    }

    @Override
    public void decrementChannelCount() {
        this.totalChannelCounter.dec();
    }

    @Override
    public void incrementConnectionCount() {
        this.totalConnectionCounter.inc();
    }

    @Override
    public void decrementConnectionCount() {
        this.totalConnectionCounter.dec();
    }

    @Override
    public void incrementConsumerCount() {
        this.totalConsumerCounter.inc();
    }

    @Override
    public void decrementConsumerCount() {
        this.totalConsumerCounter.dec();
    }

    @Override
    public void markReject() {
        this.rejectMeter.mark();
    }
}

